package lu.tudor.santec.gecamed.billing.utils.rules;

import java.util.Collection;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ChangeAct.java,v $
 * <br>Revision 1.1  2013-02-27 08:04:29  ferring
 * <br>Rule system "outsourced" to helper classes, that can be converted to drools functions, if needed
 * <br>
 */
public interface ActChangeCondition
{
	/**
	 * @param roh The RulesObjectHolder containing all important invoice and rule data.
	 * @param act The act to check
	 * @return Retrieves the code, this act should be changed to (because of the date, time or other circumstances)
	 */
	public String getCodeToChangeTo (RulesObjectsHolder roh, Act act);
	
	/**
	 * @return All codes that are concerned by this ActChangeCondition
	 */
	public Collection<String> getCodesToChange ();
	
	/**
	 * @param defaultCode The code, a <i>"conditional code"</i> is reset to,
	 * if the conditions doesn't match.<br>
	 * A <i>"conditional code"</i> is a code, that is used if one of the conditions matches.
	 */
	public void setDefaultCode (String defaultCode);
}
