/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.trash;

import java.awt.Component;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.TrashedInvoiceStub;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.utils.InvoiceWorkflow;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericRenderer;
import lu.tudor.santec.gecamed.core.utils.SSNChecker;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TrashedInvoiceStubRenderer extends GenericRenderer
	{	
	private JCheckBox						m_Selected;
	
	private ImageIcon						m_OpenState;
	private ImageIcon						m_VerifiedState;
	private ImageIcon						m_ClosedState;
	private ImageIcon						m_PrintedState;
	private ImageIcon						m_ReminderState;
	private ImageIcon						m_PaidState;
	private ImageIcon						m_CanceledState;
		
	protected TrashedInvoiceStubListModel	m_TableModel;
	protected TrashedInvoiceStub			m_TrashedInvoiceStub;
	protected Date							m_Today;
	
	private HashMap<Integer, GecamedUser>	m_TrasherLookup;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public TrashedInvoiceStubRenderer ()
     {
     super();
     
     m_Selected = new JCheckBox ();
      
     m_OpenState     = BillingModule.getIconResource("invoice_open_state.png");
     m_VerifiedState = BillingModule.getIconResource("invoice_verified_state.png");
     m_ClosedState   = BillingModule.getIconResource("invoice_closed_state.png");
     m_PrintedState  = BillingModule.getIconResource("invoice_printed_state.png");
     m_ReminderState = BillingModule.getIconResource("invoice_reminded_state.png");
     m_PaidState     = BillingModule.getIconResource("invoice_paid_state.png");
     m_CanceledState = BillingModule.getIconResource("invoice_canceled_state.png");
    
     m_TableModel 			= null;
     m_TrashedInvoiceStub   = null;
     m_TrasherLookup        = null;
     }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************
//---------------------------------------------------------------------------

private JLabel formatState (TrashedInvoiceStub p_TrashedInvoiceStub, JLabel p_Label)
	{
	String	l_InvoiceStateName;
	
	l_InvoiceStateName = InvoiceWorkflow.getInvoiceStateName (p_TrashedInvoiceStub.getState());
	
	switch (p_TrashedInvoiceStub.getState())
		{
		case InvoiceWorkflow.c_NewState:
		case InvoiceWorkflow.c_OpenState: 		p_Label.setIcon(m_OpenState);
												break;
		case InvoiceWorkflow.c_VerifiedState: 	p_Label.setIcon(m_VerifiedState);
												break;
		case InvoiceWorkflow.c_ClosedState: 	p_Label.setIcon(m_ClosedState);
												break;
		case InvoiceWorkflow.c_PrintedState:	p_Label.setIcon(m_PrintedState);
												break;	
		case InvoiceWorkflow.c_RemindedState:	p_Label.setIcon(m_ReminderState);
												break;
		case InvoiceWorkflow.c_PaidState:		p_Label.setIcon(m_PaidState);
												break;
		case InvoiceWorkflow.c_CanceledState:	p_Label.setIcon(m_CanceledState);
												break;				
		}

	p_Label.setToolTipText (Translatrix.getTranslationString("GenericInvoiceRenderer." + l_InvoiceStateName));	
	
	return p_Label;
	}

//---------------------------------------------------------------------------

private JLabel formatTrasher (Integer p_TrasherId, JLabel p_Label)
	{
	GecamedUser	l_Trasher;
	
	if ((m_TrasherLookup != null) && (m_TrasherLookup.containsKey(p_TrasherId)))
		{
		l_Trasher = m_TrasherLookup.get(p_TrasherId);
		p_Label.setText(l_Trasher.getLogin());
		p_Label.setToolTipText(l_Trasher.getName());
		}
	
	return p_Label;
	}

//---------------------------------------------------------------------------

private TrashedInvoiceStub getTableData (JTable p_Table, int p_Row)
	{
	TrashedInvoiceStub l_TrashedInvoiceStub = null;
	
	if ((p_Table != null) && (p_Table.getModel() instanceof TableSorter) && (m_TableModel == null)) 
		{
		this.setTableSorter ((TableSorter) p_Table.getModel());
		m_TableModel 	= (TrashedInvoiceStubListModel) this.getTableSorter().getTableModel();
		}
	
	if (m_TableModel != null)
		{
		p_Row = this.modelRow (p_Row);
		l_TrashedInvoiceStub = m_TableModel.getTrashedInvoiceStubAt (p_Row);
		if ((l_TrashedInvoiceStub != null) && (l_TrashedInvoiceStub.getDueDate() != null))
			{
			this.setAlarm (l_TrashedInvoiceStub.isExpired());
			}
		}
	
	return l_TrashedInvoiceStub;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void setTrasher (Collection <GecamedUser> p_Trasher)
	{
	Iterator <GecamedUser>			l_TrasherIterator;
	GecamedUser						l_Trasher;
	
	m_TrasherLookup = new HashMap <Integer, GecamedUser> ();
	
	if (p_Trasher == null) return;

	l_TrasherIterator = p_Trasher.iterator();
	while (l_TrasherIterator.hasNext())
		{
		l_Trasher = l_TrasherIterator.next();
		m_TrasherLookup.put(l_Trasher.getId(), l_Trasher);
		}
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	JLabel			l_Label;
	Component		l_Component;
	int				l_Column = -1;
	
	m_TrashedInvoiceStub = this.getTableData (p_Table, p_Row);
	l_Column			 = this.modelColumn  (p_Table, p_Column); 

	l_Label = (JLabel) super.getTableCellRendererComponent(p_Table, p_Value, p_IsSelected, p_HasFocus, p_Row, p_Column);
	l_Component = l_Label;

	if ((p_Value != null) && (m_TrashedInvoiceStub != null))
		{					
		switch (l_Column)
			{	
			case TrashedInvoiceStubListModel.c_TickedColumn :
			
				m_Selected.setSelected((Boolean)p_Value);
				m_Selected.setHorizontalAlignment (SwingConstants.CENTER);
				m_Selected.setBackground (l_Label.getBackground());
				l_Component = m_Selected;
				break;
			
			case TrashedInvoiceStubListModel.c_StateColumn :
			
				l_Label = this.formatState(m_TrashedInvoiceStub,l_Label);
				break;
				
			case TrashedInvoiceStubListModel.c_PatientNameColumn :

				l_Label.setHorizontalAlignment (SwingConstants.LEFT);
				l_Label.setText(p_Value.toString());
				break;
				
			case TrashedInvoiceStubListModel.c_PatientSSNColumn :
				
				if (m_TrashedInvoiceStub.getPatientSSN() != null)
					{
					l_Label.setHorizontalAlignment (SwingConstants.CENTER);
					l_Label.setText(SSNChecker.getFormattedSSN(m_TrashedInvoiceStub.getPatientSSN(), false));
					}
				break;
				
			case TrashedInvoiceStubListModel.c_InvoiceDateColumn :
				
				l_Label.setText(this.formatDate((Date)p_Value));
				break;
			
			case TrashedInvoiceStubListModel.c_TrasherColumn :
				l_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Label = this.formatTrasher((Integer)p_Value, l_Label);
				break;
				
			case TrashedInvoiceStubListModel.c_TrashingDateColumn :
				
				l_Label.setText(this.formatDateTime((Date)p_Value));
				break;
				
			case TrashedInvoiceStubListModel.c_AmountColumn 	:
			case TrashedInvoiceStubListModel.c_PaymentColumn 	:
			case TrashedInvoiceStubListModel.c_DeductionColumn  :
			case TrashedInvoiceStubListModel.c_BalanceColumn 	:

				l_Label.setHorizontalAlignment (SwingConstants.RIGHT);
				l_Label.setText (this.formatAmount((Double)p_Value));
				break;
				
			default :	
		
				l_Label.setText (p_Value.toString());
				break;
			}
		}		
	
	return l_Component;
	}


//***************************************************************************
//* End of Class															*
//***************************************************************************
}
