/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.trash;


/**
 *
 * @author  santec
 */

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.TrashedInvoiceStub;
import lu.tudor.santec.gecamed.billing.utils.InvoiceWorkflow;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericRenderer;
import lu.tudor.santec.gecamed.core.utils.SSNChecker;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class TrashedInvoiceStubListModel extends AbstractTableModel
    {
 	private static final long serialVersionUID = 1L;
	
    private Vector      	<TrashedInvoiceStub> m_TrashedInvoiceStubs;        
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    public static final String c_TickedHeader				= "TrashedInvoiceStubListModel.TickedHeader";
    public static final String c_StateHeader				= "TrashedInvoiceStubListModel.StatusHeader";
    public static final String c_PatientNameHeader			= "TrashedInvoiceStubListModel.PatientNameHeader";
    public static final String c_PatientSSNHeader			= "TrashedInvoiceStubListModel.PatientSSNHeader";
    public static final String c_InvoiceNumberHeader 		= "TrashedInvoiceStubListModel.InvoiceNumberHeader";
    public static final String c_InvoiceDateHeader 			= "TrashedInvoiceStubListModel.InvoiceDateHeader";
    public static final String c_TrasherHeader 				= "TrashedInvoiceStubListModel.TrasherHeader";
    public static final String c_TrashingDateHeader 		= "TrashedInvoiceStubListModel.TrashingDateHeader";
    public static final String c_AmountHeader 				= "TrashedInvoiceStubListModel.AmountHeader";
    public static final String c_PaymentHeader 				= "TrashedInvoiceStubListModel.PaymentHeader";
    public static final String c_DeductionHeader 			= "TrashedInvoiceStubListModel.DeductionHeader";
    public static final String c_BalanceHeader 				= "TrashedInvoiceStubListModel.BalanceHeader";
   
    public static final int		c_TickedColumn				= 0;
    public static final int		c_StateColumn				= 1;
    public static final int		c_PatientNameColumn			= 2;
    public static final int		c_PatientSSNColumn			= 3;
    public static final int		c_InvoiceNumberColumn		= 4;
    public static final int		c_InvoiceDateColumn			= 5;
    public static final int		c_TrasherColumn				= 6;
    public static final int		c_TrashingDateColumn		= 7;
    public static final int		c_AmountColumn				= 8;
    public static final int		c_PaymentColumn				= 9;
    public static final int		c_DeductionColumn			= 10;
    public static final int		c_BalanceColumn				= 11;
 
    static final public String c_TableHeaders [] = { 	c_TickedHeader,
    													c_StateHeader,
    													c_PatientNameHeader,
    													c_PatientSSNHeader,
    													c_InvoiceNumberHeader,
       													c_InvoiceDateHeader,
       													c_TrasherHeader,
       													c_TrashingDateHeader,
       													c_AmountHeader,
    													c_PaymentHeader,
    													c_DeductionHeader,
    													c_BalanceHeader
    													};
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public TrashedInvoiceStubListModel ()
    {
    m_TrashedInvoiceStubs  = new Vector <TrashedInvoiceStub> ();
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************
//---------------------------------------------------------------------------

private String getPatientName (TrashedInvoiceStub p_InvoiceStub)
	{
	String  l_Name = "-";

	if (p_InvoiceStub != null)
		{
		l_Name = p_InvoiceStub.getPatientFullName();
		}

	return l_Name;
	}

//---------------------------------------------------------------------------

private String getPatientSSN (TrashedInvoiceStub p_InvoiceStup)
	{
	String  l_SSN		= "-";

	if (p_InvoiceStup != null && p_InvoiceStup.getPatientSSN() != null)
		{
		l_SSN = SSNChecker.getFormattedSSN(p_InvoiceStup.getPatientSSN(), false);
		}

	return l_SSN;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_TrashedInvoiceStubs.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    TrashedInvoiceStub  l_TrashedInvoiceStub;
    
    l_TrashedInvoiceStub = new TrashedInvoiceStub ();
    
    if ((p_Row >= 0) && (p_Row < m_TrashedInvoiceStubs.size()))
        {
    	l_TrashedInvoiceStub = m_TrashedInvoiceStubs.elementAt (p_Row);
    	if (l_TrashedInvoiceStub == null) l_TrashedInvoiceStub = new TrashedInvoiceStub ();
        }
    
    switch (p_Column)
        {
        case  c_TickedColumn: 		return (l_TrashedInvoiceStub.getTicked() != null) ? l_TrashedInvoiceStub.getTicked() : false;
        case  c_StateColumn: 		return (l_TrashedInvoiceStub.getState() != null)  ? l_TrashedInvoiceStub.getState() : InvoiceWorkflow.c_OpenState;
        case  c_PatientNameColumn: 	return this.getPatientName (l_TrashedInvoiceStub);
        case  c_PatientSSNColumn: 	return this.getPatientSSN (l_TrashedInvoiceStub);
        case  c_InvoiceNumberColumn:return l_TrashedInvoiceStub.formatInvoiceNumber(Invoice.c_ShortFormat, true); 
        case  c_InvoiceDateColumn: 	return (l_TrashedInvoiceStub.getInvoiceDate() != null) ?  l_TrashedInvoiceStub.getInvoiceDate() : GenericRenderer.c_Epoch;
        case  c_TrasherColumn:		return (l_TrashedInvoiceStub.getTrasherId() != null) ?	  l_TrashedInvoiceStub.getTrasherId() : Integer.valueOf (-1);
        case  c_TrashingDateColumn: return (l_TrashedInvoiceStub.getTrashingDate() != null) ? l_TrashedInvoiceStub.getTrashingDate() : GenericRenderer.c_Epoch;
        case  c_AmountColumn: 		return (l_TrashedInvoiceStub.getAmount() != null) ?       l_TrashedInvoiceStub.getAmount() : Double.valueOf(0d);
        case  c_PaymentColumn: 		return (l_TrashedInvoiceStub.getPayment() != null) ?      l_TrashedInvoiceStub.getPayment() : Double.valueOf(0d);
        case  c_DeductionColumn: 	return (l_TrashedInvoiceStub.getDeduction() != null) ?    l_TrashedInvoiceStub.getDeduction() : Double.valueOf(0d);
        case  c_BalanceColumn: 		return (l_TrashedInvoiceStub.getBalance() != null) ?      l_TrashedInvoiceStub.getBalance() : Double.valueOf(0d);
         
        default: return "";
        }
    }
 
//---------------------------------------------------------------------------

public Class<?> getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class<?>) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------

public boolean isEditable ()
	{
	return true;
	}

//---------------------------------------------------------------------------

public void setEditable (boolean p_Editable)
	{
	}

//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
	if (p_Column == c_TickedColumn) 
		 return true;
	else return false;
    }

//---------------------------------------------------------------------------

public void setValueAt (Object p_Value, int p_Row, int p_Column)
	{
	TrashedInvoiceStub	l_TrashedInvoiceStub;
	
	if ((p_Row >= 0) && (p_Row < m_TrashedInvoiceStubs.size()))
		{
		l_TrashedInvoiceStub = m_TrashedInvoiceStubs.elementAt (p_Row);
		if (l_TrashedInvoiceStub == null) return;
	
		switch (p_Column)
			{
			case  c_TickedColumn: l_TrashedInvoiceStub.setTicked((Boolean)p_Value);
									m_TrashedInvoiceStubs.setElementAt(l_TrashedInvoiceStub, p_Row);
									break;
			}
		fireTableCellUpdated (p_Row,p_Column);
		}
	}
		
//---------------------------------------------------------------------------

public TrashedInvoiceStub	getTrashedInvoiceStubAt (int p_Row)
    {
    TrashedInvoiceStub	l_TrashedInvoiceStub;
     
    if ((p_Row >= 0) && (p_Row < m_TrashedInvoiceStubs.size()))
        {
    	l_TrashedInvoiceStub = m_TrashedInvoiceStubs.elementAt (p_Row);
        return l_TrashedInvoiceStub;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void	setTrashedInvoiceStubAt (TrashedInvoiceStub p_InvoiceStub, int p_Row)
    {     
    if ((p_InvoiceStub != null) && (p_Row >= 0) && (p_Row < m_TrashedInvoiceStubs.size()))
        {
    	m_TrashedInvoiceStubs.setElementAt(p_InvoiceStub,p_Row);
        }
    this.fireTableRowsUpdated(p_Row, p_Row);
    }
	
//---------------------------------------------------------------------------

public void addTrashedInvoiceStub (TrashedInvoiceStub p_TrashedInvoiceStub)
    {
	int	l_Row;
	
	if (p_TrashedInvoiceStub != null)    
        {    
		m_TrashedInvoiceStubs.addElement (p_TrashedInvoiceStub);
         
        l_Row = m_TrashedInvoiceStubs.size() - 1;
        fireTableRowsInserted (l_Row,l_Row);
        }
    }
	
//---------------------------------------------------------------------------

public void removeTrashedInvoiceStub (TrashedInvoiceStub p_TrashedInvoiceStub)
	{
	int	l_Index;
	
	if (p_TrashedInvoiceStub != null)
		{
		l_Index = m_TrashedInvoiceStubs.indexOf(p_TrashedInvoiceStub);
		if (l_Index >= 0) this.removeTrashedInvoiceStubAt(l_Index);		
		}
	}

//---------------------------------------------------------------------------

public void removeAllTrashedInvoiceStubs ()
	{
	int	l_LastRow;
	
	l_LastRow = m_TrashedInvoiceStubs.size() -1;

	m_TrashedInvoiceStubs.removeAllElements ();
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}

//---------------------------------------------------------------------------

public void removeTrashedInvoiceStubAt (int p_Row)
    {
    if ((p_Row >= 0) && (p_Row < m_TrashedInvoiceStubs.size()))
        {
    	m_TrashedInvoiceStubs.removeElementAt(p_Row); 
    	fireTableRowsDeleted (p_Row,p_Row);
        }
    }

//---------------------------------------------------------------------------

public int findTrashedInvoiceStub (String p_InvoiceNumber)
    {
    int 				l_Row;
    boolean				l_Found;
 	TrashedInvoiceStub	l_TrashedInvoiceStub;
    
 	l_Found = false;
 	
 	if (p_InvoiceNumber == null) return -1;
 	
 	for (l_Row = 0; (l_Row < m_TrashedInvoiceStubs.size()) && (!l_Found); l_Row++)
    		{
 		l_TrashedInvoiceStub = m_TrashedInvoiceStubs.elementAt(l_Row);
    		if (p_InvoiceNumber.equals(l_TrashedInvoiceStub.formatInvoiceNumber(Invoice.c_LongFormat, true))) l_Found = true;
    		}
    
    if (l_Found) return l_Row;
    		   else return (-1);
     }

//---------------------------------------------------------------------------

public boolean containsTrashedInvoiceStub (TrashedInvoiceStub p_TrashedInvoiceStub)
	{
	return m_TrashedInvoiceStubs.contains (p_TrashedInvoiceStub);
	}
	
//---------------------------------------------------------------------------

public void setTrashedInvoiceStubs (Collection <TrashedInvoiceStub> p_TrashedInvoiceStubs)
    {
 	if (p_TrashedInvoiceStubs == null) return;
        
    removeAllTrashedInvoiceStubs ();
 
    m_TrashedInvoiceStubs.addAll (0,p_TrashedInvoiceStubs);
     
    fireTableRowsInserted (0,p_TrashedInvoiceStubs.size());
    }

//---------------------------------------------------------------------------

public void addTrashedInvoiceStubs (Collection <TrashedInvoiceStub> p_TrashedInvoiceStubs)
	{
	if (p_TrashedInvoiceStubs == null) return;
  
	m_TrashedInvoiceStubs.addAll (0,p_TrashedInvoiceStubs);
     
    fireTableRowsInserted (0,p_TrashedInvoiceStubs.size());	
	}

//---------------------------------------------------------------------------

public Collection <TrashedInvoiceStub> getTrashedInvoiceStubs ()
    {
	Vector <TrashedInvoiceStub> l_TrashedInvoiceStubs;
	
	l_TrashedInvoiceStubs = new Vector <TrashedInvoiceStub> (m_TrashedInvoiceStubs);
	
	return l_TrashedInvoiceStubs;
    }    
        
//---------------------------------------------------------------------------

public Collection <TrashedInvoiceStub> getTickedInvoiceStubs ()
    {
	Collection <TrashedInvoiceStub> 	l_TickedInvoiceStubs;
	Iterator <TrashedInvoiceStub>		l_InvoiceStubIterator;
	TrashedInvoiceStub					l_TrashedInvoiceStub;
	
	l_TickedInvoiceStubs = new ArrayList <TrashedInvoiceStub> (); 
	
	l_InvoiceStubIterator = m_TrashedInvoiceStubs.iterator();
	while (l_InvoiceStubIterator.hasNext())
		{
		l_TrashedInvoiceStub = l_InvoiceStubIterator.next();
		if (l_TrashedInvoiceStub.getTicked()) l_TickedInvoiceStubs.add(l_TrashedInvoiceStub);
		}
	
	return l_TickedInvoiceStubs;
    }    

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
