/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.trash;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.billing.gui.invoice.InvoiceNumberFormatter;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader.SearchTableHeader;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.toedter.calendar.JDateChooser;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class TrashedInvoiceSearchTableHeader extends SearchTableHeader implements PropertyChangeListener,
																		   		  ActionListener,
																		   		  Relocalizable
	{
	private SimpleDateFormat    	m_DateFormat;
	
	private JFormattedTextField		m_InvoiceNumber;
	private	JDateChooser			m_DateChooser;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public 	TrashedInvoiceSearchTableHeader (JTable p_Table)
	{
	super (p_Table);
	
	m_InvoiceNumber = new JFormattedTextField (new InvoiceNumberFormatter(InvoiceNumberFormatter.c_ShortFormat));
	m_InvoiceNumber.addActionListener(this);
	m_InvoiceNumber.addKeyListener(this);
	
	m_DateChooser = GECAMedGuiUtils.getDateChooser(false);
	m_DateChooser.addPropertyChangeListener(this);
	m_DateChooser.setVerifyInputWhenFocusTarget(false);
	m_DateChooser.getDateEditor().addPropertyChangeListener(this);
	m_DateChooser.addKeyListener(this);
	
	this.relocalize();
	
	this.setEnabled (TrashedInvoiceStubListModel.c_InvoiceNumberColumn, true);
	this.setMutualExclusive(TrashedInvoiceStubListModel.c_InvoiceNumberColumn, true);
	
	this.setEnabled (TrashedInvoiceStubListModel.c_InvoiceDateColumn,   true);
	this.setMutualExclusive (TrashedInvoiceStubListModel.c_InvoiceDateColumn,  true);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

protected JComponent getEditingComponent (int p_Column)
	{	
	switch (p_Column)
		{
		case TrashedInvoiceStubListModel.c_InvoiceNumberColumn:
			
			m_InvoiceNumber.setValue (InvoiceNumberFormatter.c_EmptyFieldShort);
			return m_InvoiceNumber;

		case TrashedInvoiceStubListModel.c_InvoiceDateColumn:
			
			m_DateChooser.setDate(new Date());
			return m_DateChooser;
				
		default: return super.getEditingComponent(p_Column);	
		}
	}

//---------------------------------------------------------------------------

protected Object getEditingComponentValue (JComponent p_Component, int p_Column)
	{
	String					l_Text;
	Object					l_Value = null;
	Date 					l_Date;
	
	switch (p_Column)
		{
		case TrashedInvoiceStubListModel.c_InvoiceNumberColumn:
		
			if (p_Component instanceof JFormattedTextField)
				{
				l_Text = (String) m_InvoiceNumber.getValue();
				if (InvoiceNumberFormatter.c_EmptyFieldShort.equals(l_Text))
					 l_Value  = null;
				else try 
					{
					l_Value = Integer.parseInt(l_Text);
					}
				catch (NumberFormatException p_Exception)
					{
					l_Value = Integer.valueOf (0);
					}
				}
			break;
		
		case TrashedInvoiceStubListModel.c_InvoiceDateColumn:
		
			if (p_Component instanceof JDateChooser)
				{
				l_Date = m_DateChooser.getDate();
				l_Value = l_Date;
				}
			break;

		default: super.getEditingComponentValue(p_Component, p_Column);
		}
	
	return l_Value;
	}

//---------------------------------------------------------------------------

protected String getEditingComponentText (JComponent p_Component, int p_Column)
	{
	Object  l_Value;
	String	l_Text = SearchTableHeader.c_EmptyValue;
	
	l_Value = this.getEditingComponentValue(p_Component, p_Column);
	if (l_Value == null) return SearchTableHeader.c_EmptyValue;

	switch (p_Column)
		{
		case TrashedInvoiceStubListModel.c_InvoiceNumberColumn:
			
			if (l_Value instanceof Integer)
				{
				l_Text = l_Value.toString();
				if (InvoiceNumberFormatter.c_EmptyFieldShort.equals(l_Text)) 
					l_Text = SearchTableHeader.c_EmptyValue;	
				}
			break;
			
		case TrashedInvoiceStubListModel.c_InvoiceDateColumn:
			
			if (l_Value instanceof Date)
				{
				l_Text = m_DateFormat.format((Date)l_Value);
				}
			break;
		}
			
	return l_Text;
	}

//---------------------------------------------------------------------------

public void propertyChange(PropertyChangeEvent p_Event) 
	{
	if (   (p_Event.getSource() == m_DateChooser) 
			&& ("date".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}
	else if ( (p_Event.getSource() == m_DateChooser.getDateEditor())
			&& ("value".equals(p_Event.getPropertyName())))
		{
		this.endEditing();
		}	
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource() == m_InvoiceNumber)
		{
		this.endEditing();
		}
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	Locale l_Locale;
	
	l_Locale = Translatrix.getLocale ();
  	
	if (l_Locale != null) 
		 m_DateFormat = new SimpleDateFormat ("d MMMM yyyy",l_Locale);
	else m_DateFormat = new SimpleDateFormat ("d MMMM yyyy");   
	
	m_DateChooser.setDateFormatString("d MMMM yyyy");   
	m_DateChooser.getDateEditor().setLocale (Translatrix.getLocale());	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
