package lu.tudor.santec.gecamed.billing.gui.trash;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import bizcal.util.DateUtil;

import com.toedter.calendar.JDateChooser;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.TrashedInvoiceStub;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.utils.WindowToolbox;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.core.utils.querybuilder.HibernateCondition;
import lu.tudor.santec.gecamed.core.utils.querybuilder.HibernateOperator;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;
import lu.tudor.santec.i18n.Translatrix;

/**
 * @author hermenj
 *
 * @version
 * <br>$Log: TrashClearDialog.java,v $
 */
public class TrashClearDialog extends GECAMedBaseDialogImpl {

	private static final long serialVersionUID = 1L;
	
	/**
	 * static logger for this class
	 */
	private static Logger logger = Logger.getLogger(TrashClearDialog.class.getName());

	private JDateChooser dateChooser;

	private JCheckBox sureBox;

	private JLabel label;
	
	private Collection<Integer> IDs = new ArrayList<Integer>();
	
	private DateFormat df = GECAMedGuiUtils.getDateFormat(false);

	private TrashPanel trashPanel;
	
	protected TrashClearDialog(TrashPanel trashPanel) {
		super((JDialog) WindowToolbox.getOwnerFrame(trashPanel), Translatrix.getTranslationString("TrashPanel.ClearTrashButton"), GECAMedBaseDialogImpl.OK_CANCEL_BUTTON_MODE);
		
		this.trashPanel = trashPanel;
		
		JPanel p = new JPanel(new BorderLayout(5,5));
		
		this.dateChooser = GECAMedGuiUtils.getDateChooser(false);
		this.dateChooser.setDate(DateUtil.moveByYear(new Date(), -3));
		this.dateChooser.addPropertyChangeListener("date", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent evt) {
				searchAffectedInvoices();
			}
		});
		p.add(new NamedComponent(Translatrix.getTranslationString("TrashPanel.DeleteBefore"), this.dateChooser, true, JLabel.VERTICAL), BorderLayout.NORTH);
				
		this.label = new JLabel();
		p.add(this.label, BorderLayout.CENTER);
		
		this.sureBox = new JCheckBox(Translatrix.getTranslationString("TrashPanel.ReallyDelete"));
		p.add(this.sureBox, BorderLayout.SOUTH);
		
		this.sureBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				okButton.setEnabled(sureBox.isSelected());
			}
		});
		
		this.okButton.setEnabled(false);
		
		addMainPanel(p);
		searchAffectedInvoices();
		this.setSize(300, 250);
		this.validate();
	}
	
	private void searchAffectedInvoices() {
		WhereClause w = new WhereClause();
		HibernateCondition c = new HibernateCondition("invoiceDate", HibernateOperator.c_LowerThanOperator, "iDate", dateChooser.getDate());
		w.addCondition(c);
		
		long count;
		try {
			count = this.trashPanel.getTrashedInvoiceStubInterface().getInvoiceStubCountByWhereClause(w);
			this.label.setText(Translatrix.getTranslationString("TrashPanel.DeleteTrashed", new String[] {count+"", df.format(dateChooser.getDate())}));
		} catch (Exception e) {
			logger.log(Level.ERROR, "Error counting affected trashed invoices....", e);
		}
		
	}
	
	public void setDate(Date d) {
		dateChooser.setDate(d);
	}
	
	public Date getDate() {
		return dateChooser.getDate();
	}
	
	public Collection<TrashedInvoiceStub> getTrashedInvoices2Delete() {
		if (!sureBox.isSelected()) return null;
				
		WhereClause w = new WhereClause();
		HibernateCondition c = new HibernateCondition("invoiceDate", HibernateOperator.c_LowerThanOperator, "iDate", dateChooser.getDate());
		w.addCondition(c);
		
		try {
			return this.trashPanel.getTrashedInvoiceStubInterface().getInvoiceStubsByWhereClause(w);
		} catch (Exception e) {
			logger.log(Level.ERROR, "Error fetching affected trashed invoices....", e);
		}
		return null;
	}
	
	
}
