/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

import javax.swing.JComponent;
import javax.swing.TransferHandler;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public abstract class TemplateTransferHandler extends TransferHandler 
	{   
    protected abstract InvoiceTemplate exportTemplate 	 (JComponent p_Component);
    protected abstract void 		   importTemplate 	 (JComponent p_Component, InvoiceTemplate p_Template);
    protected abstract void 		   cleanup			 (JComponent p_Component, boolean p_Remove);
    
    protected Transferable createTransferable	(JComponent p_Component) 
    	{
        InvoiceTemplate		l_Template = null;
    	
        l_Template = exportTemplate (p_Component);

        return new TemplateTransferable (l_Template);    	
        }
    
//---------------------------------------------------------------------------

public int getSourceActions(JComponent p_Component) 
   {
   return TransferHandler.COPY_OR_MOVE;
   }
    
//---------------------------------------------------------------------------
     
public boolean importData (JComponent p_Component, Transferable p_Transferable) 
	{
    if (canImport(p_Component, p_Transferable.getTransferDataFlavors())) 
    	{
        try {
            InvoiceTemplate l_Template = (InvoiceTemplate)p_Transferable.getTransferData(TemplateTransferable.c_TemplateFlavor);
            importTemplate (p_Component, l_Template);
            return true;
        	} 
        catch (UnsupportedFlavorException p_Exception) 
        	{
        	} 
        catch (IOException p_Exception) 
        	{
        	}
    	}
    return false;
	}
    
 //---------------------------------------------------------------------------

protected void exportDone (JComponent p_Component, Transferable p_Data, int p_Action) 
	{
    cleanup(p_Component, p_Action == MOVE);
	}
    
//---------------------------------------------------------------------------

public boolean canImport (JComponent c, DataFlavor[] p_Flavors) 
	{
    DataFlavor l_Flavor;
    
    l_Flavor = TemplateTransferable.c_TemplateFlavor;
	
	for (int i = 0; i < p_Flavors.length; i++) 
    	{
        if (l_Flavor.equals(p_Flavors[i])) 
        	{
            return true;
        	}
    	}
    return false;
	}

//---------------------------------------------------------------------------

}
