/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

import java.awt.Color;
import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Rate;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.TemplateRate;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class TemplateRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              	m_Label;
	private ImageIcon				m_PrivateIcon;   
	private ImageIcon				m_PublicIcon;   

	private TemplateListModel		m_TableModel;
	private InvoiceTemplate			m_Template;
	private int						m_LastRow;
	private int						m_HighlightedRows;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
 
	public static final String c_PrivateTip		= "TemplateRenderer.PrivateTip";
	public static final String c_PublicTip		= "TemplateRenderer.PublicTip";

	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public TemplateRenderer ()
      {
      super();

      m_HighlightedRows = -1;
      
      m_Label = new JLabel ();
      m_Label.setOpaque(true);
      m_Label.setHorizontalAlignment (SwingConstants.CENTER);
       
      m_PrivateIcon = BillingModule.getIconResource ("private_tiny.png");
      m_PublicIcon = BillingModule.getIconResource ("public_tiny.png");
       
      this.relocalize();       
      }

//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
     
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
 	}

//---------------------------------------------------------------------------

public void setNumberOfHighlightedRows (int p_HighlightedRows)
	{
	m_HighlightedRows = p_HighlightedRows;
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component		l_Component;
	Color			l_Background;
	int				l_Column = -1;
	StringBuffer 	l_ToolTipText;
	String 			l_RateDescription;
	Rate 			l_Rate;
	
	if ((p_Table != null) && (m_TableModel == null)) 
		{
		m_TableModel 	= (TemplateListModel) p_Table.getModel();
		m_LastRow	  	= -1;
		}

	if ((m_TableModel != null) && (p_Row != m_LastRow))
		{
		m_Template = m_TableModel.getTemplateAt(p_Row);
		m_LastRow = p_Row;
		}

	m_Label.setText("");
	m_Label.setIcon (null);
	
	/**
	 * @author ferring
	 * Set all acts of this template listed as tool tip
	 */
	l_ToolTipText = new StringBuffer("<html>");
	for (TemplateRate l_TemplateRate : m_Template.getTemplateRates()) 
		{
		l_Rate = l_TemplateRate.getRate();
		l_RateDescription = l_Rate.getLabel();
		if (l_RateDescription.length() > 35) 
			{
			l_RateDescription = l_RateDescription.substring(0, 30) + "...";
			}
		
		l_ToolTipText.append("<tr>")
				.append(l_Rate.getCode() + l_TemplateRate.getSuffixes())
				.append("</td><td><i>")
				.append(l_RateDescription)
				.append("</i></td></tr>");
		}
	m_Label.setToolTipText (l_ToolTipText.toString());
	
	if ((p_Value != null) && (m_Template != null)) 
		{
		l_Column = this.modelColumn(p_Table, p_Column);		
		
		switch (l_Column)
			{
			case TemplateListModel.c_VisibilityColumn :
	
				if (((Integer)p_Value).equals(TemplateListModel.c_Global)) 
					{
					m_Label.setIcon (m_PublicIcon);
					m_Label.setToolTipText(Translatrix.getTranslationString(c_PublicTip));
					}
				else 
					{
					m_Label.setIcon (m_PrivateIcon);
					m_Label.setToolTipText(Translatrix.getTranslationString(c_PrivateTip));
					}
									
				break;
		
			default:
		
				m_Label.setText (p_Value.toString());
				break;
			}
		}
	
	l_Component = m_Label;
	
	if (p_Table != null) l_Component.setEnabled (p_Table.isEnabled());

	if (p_Row >= m_HighlightedRows)
		{
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
			 							   GECAMedColors.c_EvenLineBackground;
		}
	else
		{
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_YellowOddLineBackground: 
			 							   GECAMedColors.c_YellowEvenLineBackground;
		}
	
	
	if ((p_Table != null) && (p_IsSelected)) 
		{
		l_Component.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		l_Component.setBackground(l_Background);
		}

	return l_Component;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
