/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

/**
 *
 * @author  santec
 */

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Vector;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class TemplateListModel extends AbstractTableModel
    {
 	private static final long serialVersionUID = 1L;
  	
    private Vector      	<InvoiceTemplate> m_Templates;        
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    public static final Integer	c_Global				= -1;
    
    public static final String c_ShortCutHeader		 	= "TemplateListModel.ShortCutHeader";
    public static final String c_DescriptionHeader		= "TemplateListModel.DescriptionHeader";
    public static final String c_VisibilityHeader 		= "TemplateListModel.VisibilityHeader";
           
    public static final int	   c_ShortCutColumn			= 0;
    public static final int	   c_DescriptionColumn		= 1;
    public static final int	   c_VisibilityColumn		= 2;
       
    static final public String c_TableHeaders [] = { 	c_ShortCutHeader,
    													c_DescriptionHeader,
    													c_VisibilityHeader   };
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public TemplateListModel ()
    {	
    m_Templates= new Vector <InvoiceTemplate> ();
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//---------------------------------------------------------------------------

private void swapTemplatesAt (int p_RowA, int p_RowB)
	{
	InvoiceTemplate	l_TemplateA;
	InvoiceTemplate	l_TemplateB;
	int				l_SequenceNumberA;
	int				l_SequenceNumberB;
	
	l_TemplateA = this.getTemplateAt(p_RowA);
	l_TemplateB = this.getTemplateAt(p_RowB);
	
	if ((l_TemplateA == null) || (l_TemplateB == null)) return;
	
	l_SequenceNumberA = l_TemplateA.getSequenceNumber();
	l_SequenceNumberB = l_TemplateB.getSequenceNumber();
	
	l_TemplateA.setSequenceNumber(l_SequenceNumberB);
	l_TemplateB.setSequenceNumber(l_SequenceNumberA);
	
	this.setTemplateAt (l_TemplateA, p_RowB);
	this.setTemplateAt (l_TemplateB, p_RowA);
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Templates.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    InvoiceTemplate  l_Template = null;
    
    if ((p_Row >= 0) && (p_Row < m_Templates.size()))
        {
    	l_Template = m_Templates.elementAt (p_Row);
    	if (l_Template == null) l_Template = new InvoiceTemplate ();
        }
    else  l_Template = new InvoiceTemplate ();
    
    switch (p_Column)
        {
        case  c_ShortCutColumn		: return (l_Template.getShortcut() != null) ? l_Template.getShortcut() : "";
        case  c_DescriptionColumn	: return (l_Template.getLabel() != null) ? l_Template.getLabel() : "";       
        case  c_VisibilityColumn	: return (l_Template.getUserId() != null) ? l_Template.getUserId() : c_Global;
                
        default: return "";
        }
    }
        
//---------------------------------------------------------------------------

public Class getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------
/**
 * queries the ability to be edited of the cell specified by p_Row and p_Column
 * @param p_Row specifies the row to be queried
 * @param p_Column specifies the column to be queried
 * @return <CODE>true</CODE> if the specified cell is editable, <CODE>false</CODE> otherwise
 */
//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
    return false;
    	}
 
//---------------------------------------------------------------------------

public InvoiceTemplate	getTemplateAt (int p_Row)
    {
    InvoiceTemplate  l_Template;
     
    if ((p_Row >= 0) && (p_Row < m_Templates.size()))
        {
    	l_Template = m_Templates.elementAt (p_Row);
        return l_Template;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void	setTemplateAt (InvoiceTemplate p_Template, int p_Row)
    {
     if ((p_Template != null) && (p_Row >= 0) && (p_Row < m_Templates.size()))
        {
    	m_Templates.setElementAt(p_Template, p_Row);
        this.fireTableRowsUpdated(p_Row, p_Row);
        }
    }
	
//---------------------------------------------------------------------------

public void	insertTemplateAt (InvoiceTemplate p_Template, int p_Row)
    {
     if ((p_Template != null) && (p_Row >= 0) && (p_Row < m_Templates.size()))
        {
    	m_Templates.insertElementAt(p_Template, p_Row);
        fireTableRowsInserted (p_Row,p_Row);
        }
    }
//---------------------------------------------------------------------------

public void moveTemplateUp (int p_Row)
	{
	if (p_Row > 0) this.swapTemplatesAt(p_Row, (p_Row-1));
	}

//---------------------------------------------------------------------------

public void moveTemplateDown (int p_Row)
	{
	if (p_Row < (m_Templates.size() - 1)) this.swapTemplatesAt(p_Row, (p_Row+1));
	}

//---------------------------------------------------------------------------

public void addTemplate (InvoiceTemplate p_Template)
    {
    if (p_Template != null)    
        {    
    	p_Template.setSequenceNumber(m_Templates.size());
    	m_Templates.addElement (p_Template);
    	fireTableChanged(new TableModelEvent(this));
        }
    }
	
//---------------------------------------------------------------------------

public int findTemplate (String p_Shortcut)
    {
  	String			l_Shortcut;
  	int 			l_Row;
    int				l_Position = -1;
    
    if (p_Shortcut == null) p_Shortcut = "";
    
    for (l_Row = 0; ((l_Row < m_Templates.size()) && (l_Position < 0)); l_Row++)
        {
    	l_Shortcut = (String) this.getValueAt(l_Row, c_ShortCutColumn);
    	if (l_Shortcut.equals (p_Shortcut)) l_Position = l_Row;
    	}
    return l_Position;
    }

//---------------------------------------------------------------------------

public void removeAllTemplates ()
	{
	int l_LastRow;
	
	l_LastRow = m_Templates.size() -1;
	
	m_Templates.removeAllElements ();
	fireTableChanged(new TableModelEvent(this));
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}

//---------------------------------------------------------------------------

public void removeTemplateAt (int p_Row)
    {
    if ((p_Row >= 0) && (p_Row < m_Templates.size()))
        {
    	m_Templates.removeElementAt(p_Row);    
    	fireTableRowsDeleted (p_Row,p_Row);
        }
    }

//---------------------------------------------------------------------------

public void setTemplates (Collection <InvoiceTemplate> p_Templates)
    {
     if (p_Templates == null) return;
        
    this.removeAllTemplates();
    m_Templates.addAll(p_Templates);
     
    fireTableRowsInserted (0,m_Templates.size());
    }

//---------------------------------------------------------------------------

public Collection <InvoiceTemplate> getTemplates ()
    {
	LinkedHashSet <InvoiceTemplate> l_Templates;
	
	l_Templates = new LinkedHashSet <InvoiceTemplate> (m_Templates);
	
	return l_Templates;
    }    
        
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
