/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

/*
 * TableTransferHandler.java is used by the 1.4
 * ExtendedDnDDemo.java example.
 */

import javax.swing.JComponent;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class TableTransferHandler extends TemplateTransferHandler 
	{
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private int m_SourceRow = -1;
    private int m_InsertRow = -1; 	//Location where items were added
 
//---------------------------------------------------------------------------

protected InvoiceTemplate exportTemplate (JComponent p_Component) 
	{
	JTable 				l_Source;
 	TemplateListModel	l_Model;
	InvoiceTemplate		l_Template = null;
	
    l_Source = (JTable) p_Component;
    l_Model = (TemplateListModel) l_Source.getModel();
    
    if (l_Source.getSelectedRowCount() == 1)
    	{
    	m_SourceRow = l_Source.getSelectedRow();
    	l_Template = l_Model.getTemplateAt (m_SourceRow);
    	}

    return l_Template;
	}

//---------------------------------------------------------------------------

protected void importTemplate (JComponent p_Component, InvoiceTemplate p_Template) 
	{
    JTable 				l_Target;
 	TemplateListModel	l_Model;
 	int					l_TargetRow;
 	int					l_LastRow;
 	
    l_Target = (JTable) p_Component;
    l_Model = (TemplateListModel) l_Target.getModel();
    
    l_TargetRow = l_Target.getSelectedRow();
        
    if (l_TargetRow == m_SourceRow) return;
 
    l_LastRow = l_Model.getRowCount();
        
    if (l_TargetRow < 0) l_TargetRow = l_LastRow;
//        else {
//        	 l_TargetRow = (l_TargetRow < l_LastRow)?l_TargetRow+1:l_LastRow;	 
//        	 }
    
    m_InsertRow = l_TargetRow;
 	if (m_InsertRow < l_LastRow)
 		 l_Model.insertTemplateAt(p_Template, m_InsertRow);
 	else l_Model.addTemplate (p_Template);
	}
    
//---------------------------------------------------------------------------

protected void cleanup	(JComponent p_Component, boolean p_Remove) 
	{
    JTable 				l_Source;
    TemplateListModel	l_Model;
    
    if (p_Remove && m_SourceRow >= 0)
    	{
    	l_Source = (JTable) p_Component;
    	l_Model = (TemplateListModel) l_Source.getModel();

    	if (m_InsertRow <= m_SourceRow) m_SourceRow++;
    		{
        	l_Model.removeTemplateAt(m_SourceRow);
        	}
        
        m_InsertRow = -1;
    	m_SourceRow = -1;
    	}
	}
//---------------------------------------------------------------------------

	}
