/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.templates;

import java.awt.Component;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.widgets.dragnghost.GhostComponentAdapter;
import lu.tudor.santec.gecamed.core.gui.widgets.dragnghost.GhostGlassPane;
import lu.tudor.santec.gecamed.core.gui.widgets.dragnghost.GhostMotionAdapter;

public class GhostTableRowAdapter extends GhostComponentAdapter
{
	private Component			m_Component = null;
	private GhostMotionAdapter 	m_MotionAdapter = null;
	
//---------------------------------------------------------------------------

    public GhostTableRowAdapter (GhostGlassPane glassPane, String action) {
        super(glassPane, action);
    }
	
//---------------------------------------------------------------------------
	
public void mousePressed (MouseEvent p_Event) 
	{
    TableCellRenderer		l_Renderer;
   
	JComponent c = (JComponent)p_Event.getSource();
            
    if (c instanceof JTable)
    	{
        JTable l_Table = (JTable) c;
        int l_Row = l_Table.getSelectedRow();
        int l_Column = l_Table.getSelectedColumn();
            	
        l_Renderer = l_Table.getCellRenderer(l_Row, l_Column);
        m_Component = l_Table.prepareRenderer(l_Renderer, l_Row, l_Column);
        
        m_MotionAdapter = new GhostMotionAdapter (glassPane);
        
        m_Component.addMouseMotionListener(m_MotionAdapter);
        m_Component.addMouseListener(this);
        
     	p_Event.setSource (m_Component);
    	super.mousePressed(p_Event);
        
    	}
    else p_Event.consume();
	}

//---------------------------------------------------------------------------
	
public void mouseReleased (MouseEvent p_Event) 
	{
	if (p_Event.getSource().equals(m_Component))
		{
		super.mouseReleased(p_Event);
		m_Component.removeMouseListener(this);
		if (m_MotionAdapter != null) m_Component.removeMouseMotionListener(m_MotionAdapter);
    	}
    else p_Event.consume();
	}

//---------------------------------------------------------------------------

}
