/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.suffix;


import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Suffix;

/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class SuffixEditorField extends AbstractCellEditor implements TableCellEditor,
																	 ActionListener
    {
	private JButton					m_StartEditingButton;
	private SuffixChooser 			m_SuffixChooser;

	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public SuffixEditorField(Collection <Suffix> p_Suffixes) 
    {
	super ();
		
	m_SuffixChooser = new SuffixChooser (this,p_Suffixes);
	m_StartEditingButton = new JButton();
	m_StartEditingButton.addActionListener(m_SuffixChooser);
	m_StartEditingButton.setBorderPainted(false);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************

//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
	return m_SuffixChooser.getChosenSuffixes();
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent(JTable p_Table, Object p_InitialValue, 
										  boolean p_IsSelected, int p_Row, int p_Column) 
	{	
	m_SuffixChooser.setChosenSuffixes((String)p_InitialValue);
	m_StartEditingButton.setText((String)p_InitialValue);
	return m_StartEditingButton;
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent e) 
	{
	m_SuffixChooser.actionPerformed(e);
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

