/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.statement;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Statement;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.utils.StatementWorkflow;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class StatementRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              	m_Label;
	private DateFormat				m_DateFormat;
	
	private String              	m_StateColumn;
	private String              	m_ThirdPartyColumn;
	private String              	m_ReferenceColumn;
	private String              	m_StartDateColumn;
	private String              	m_EndDateColumn;
	
	private ImageIcon				m_OpenState;
	private ImageIcon				m_ClosedState;
	private ImageIcon				m_PrintedState;
	private ImageIcon				m_PaidState;
	private ImageIcon				m_CanceledState;

	private StatementListModel		m_TableModel;
	private	TableSorter				m_StatementSorter;
	private Statement				m_Statement;
	private int						m_LastRow;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
    	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public StatementRenderer ()
      {
      super();

      m_Label = new JLabel ();
      m_Label.setOpaque(true);
      m_Label.setHorizontalAlignment (SwingConstants.CENTER);
           
      m_OpenState     = BillingModule.getIconResource("stmnt_open_state_tiny.png");
      m_ClosedState   = BillingModule.getIconResource("stmnt_closed_state_tiny.png");
      m_PrintedState  = BillingModule.getIconResource("stmnt_printed_state_tiny.png");
      m_PaidState     = BillingModule.getIconResource("stmnt_paid_state_tiny.png");
      m_CanceledState = null;

      
      this.relocalize();       
      }

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

private String dateToString (Date p_Date)
	{
	if (p_Date.equals (StatementListModel.c_Epoch))
		 return "";
	else return m_DateFormat.format (p_Date);
	}

//---------------------------------------------------------------------------

private void formatState (Statement p_Statement)
	{
	String	l_InvoiceStateName;
	
	l_InvoiceStateName = StatementWorkflow.getStatementStateName(p_Statement);
	
	switch (p_Statement.getState())
	{
	case StatementWorkflow.c_NewState :
	case StatementWorkflow.c_OpenState :
	
		m_Label.setIcon(m_OpenState);
			
		break;
	
	case StatementWorkflow.c_ClosedState :
		
		m_Label.setIcon(m_ClosedState);
		break;
	
	case StatementWorkflow.c_PrintedState :					
		
		m_Label.setIcon(m_PrintedState);
		break;
	
	case StatementWorkflow.c_SettledState:
		
		m_Label.setIcon(m_PaidState);
		break;
		
	case StatementWorkflow.c_CanceledState:
		
		m_Label.setIcon(m_CanceledState);
		break;				
	}

	m_Label.setToolTipText (Translatrix.getTranslationString("StatementRenderer." + l_InvoiceStateName));	
	}

//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_StatementSorter != null) && m_StatementSorter.isSorting())
		{
		l_ModelRow = m_StatementSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
     
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{

	m_DateFormat = GECAMedGuiUtils.getDateFormat(false);
   
    m_StateColumn       = Translatrix.getTranslationString(StatementListModel.c_StateHeader);
    m_ThirdPartyColumn  = Translatrix.getTranslationString(StatementListModel.c_ThirdPartyPayerHeader);
    m_ReferenceColumn 	= Translatrix.getTranslationString(StatementListModel.c_ReferenceHeader);
    m_StartDateColumn	= Translatrix.getTranslationString(StatementListModel.c_StartDateHeader);
    m_EndDateColumn   	= Translatrix.getTranslationString(StatementListModel.c_EndDateHeader);
 	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component		l_Component;
	Color			l_Background;
	int				l_Row;
	int				l_Column;
	
	if ((p_Table != null) && (m_TableModel == null)) 
		{
		m_StatementSorter = (TableSorter) p_Table.getModel();
		m_TableModel 	= (StatementListModel) m_StatementSorter.getTableModel();
		m_LastRow	  	= -1;
		}
	
	if (m_TableModel != null)  //&& (p_Row != m_LastRow))
		{
		l_Row = this.modelRow (p_Row);
		m_Statement = m_TableModel.getStatementAt(l_Row);
		m_LastRow = l_Row;
		}
	
	m_Label.setText ("");
	m_Label.setIcon (null);
	m_Label.setToolTipText (null);

	if ((p_Value != null) && (m_Statement != null))
		{	
		l_Column = this.modelColumn(p_Table, p_Column);

		switch (l_Column)
			{
			case StatementListModel.c_StateColumn: 
				
				this.formatState(m_Statement);
				l_Component = m_Label;
				break;
	
			case StatementListModel.c_ThirdPartyPayerColumn: 
				
				m_Label.setText ((String)p_Value);
				m_Label.setToolTipText(p_Value.toString());

				l_Component = m_Label;
				break;
				
			case StatementListModel.c_PhysicianColumn: 

				m_Label.setText ((String)p_Value);
				m_Label.setToolTipText(p_Value.toString());
				l_Component = m_Label;
				break;
		
			case StatementListModel.c_ReferenceColumn: 

				m_Label.setText ((String)p_Value);
				
				l_Component = m_Label;
				break;
		
			case StatementListModel.c_StartDateColumn: 
				
				m_Label.setText (this.dateToString ((Date)p_Value));
				l_Component = m_Label;
				break;
				
			case StatementListModel.c_EndDateColumn: 

				m_Label.setText (this.dateToString ((Date)p_Value));
				l_Component = m_Label;
				break;
				
			default:
				
				m_Label.setText (p_Value.toString());
				l_Component = m_Label;
			}
		}
	else
		{
		m_Label.setText ("");
		l_Component = m_Label;
		}
//	l_Component.setEnabled (p_Table.isEnabled());

	l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
		 							   GECAMedColors.c_EvenLineBackground;

	if ((p_Table != null) && (p_IsSelected)) 
		{
		l_Component.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		l_Component.setBackground(l_Background);
		}

	return l_Component;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
