/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.statement;


import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.billing.gui.BillingModule;

/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class SettlementEditorField extends AbstractCellEditor implements TableCellEditor,
																	     ActionListener
    {
	private JToggleButton	m_SettledButton;
	private ImageIcon		m_SettledIcon;
	private ImageIcon		m_UnSettledIcon;
	
	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public SettlementEditorField () 
    {
	super ();
		
	m_SettledButton = new JToggleButton ();
	m_SettledButton.addActionListener(this);
	m_SettledButton.setBorderPainted(false);
    
	m_SettledIcon    = BillingModule.getIconResource("inv_paid_state_tiny.png");
	m_UnSettledIcon  = BillingModule.getIconResource("inv_unpaid_state_tiny.png");
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************

//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
	return m_SettledButton.isSelected();
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent(JTable p_Table, Object p_InitialValue, 
										  boolean p_IsSelected, int p_Row, int p_Column) 
	{	
	if (p_InitialValue instanceof Boolean)
		{
		m_SettledButton.setSelected((Boolean)p_InitialValue);
		}
	return m_SettledButton;
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource()==m_SettledButton)
		{
		if (m_SettledButton.isSelected())
			m_SettledButton.setIcon(m_SettledIcon);
		else m_SettledButton.setIcon(m_UnSettledIcon);
		
		this.stopCellEditing();
		}
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

