/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.settlement;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractListModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Payment;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class PaymentListModel extends AbstractListModel 
	{
	private static final long serialVersionUID = 1L;
	
	private Vector <Payment> m_Payments;
	private Hashtable <String, Integer> m_PaymentLookup;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
	
public 	PaymentListModel ()
	{
	m_Payments = new Vector <Payment> ();
	m_PaymentLookup = new Hashtable <String, Integer> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	
public Payment getElementAt (int p_Index) 
	{
	if ((p_Index >= 0) && (p_Index < m_Payments.size()))
		{
		return m_Payments.elementAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getSize() 
	{
	return m_Payments.size();
	}

//---------------------------------------------------------------------------

public boolean contains (Payment p_Candidate)
	{
	if (p_Candidate != null)
		 return m_PaymentLookup.containsKey(p_Candidate.getMethod());
	else return false;
	}

//---------------------------------------------------------------------------

public int getElementPosition (Payment p_Candidate)
	{
	if (this.contains (p_Candidate))
		{
		return m_PaymentLookup.get(p_Candidate.getMethod());
		}
	else return -1;
	}

//---------------------------------------------------------------------------

public void setPayments (Collection <Payment> p_Payments)	
	{
	Iterator <Payment> 	l_PaymentIterator;
	Payment			 	l_Payment;
	int					l_Position = 0;
	
	m_Payments.removeAllElements();
	m_PaymentLookup.clear();
	
	if (p_Payments != null)
		{
		l_PaymentIterator = p_Payments.iterator();
		while (l_PaymentIterator.hasNext())
			{
			l_Payment = l_PaymentIterator.next();
			m_Payments.add(l_Payment);
			m_PaymentLookup.put(l_Payment.getMethod(), l_Position++);
			}
		}
	}

//---------------------------------------------------------------------------

public void setPayments (Payment [] p_Payments)	
	{
	Payment		l_Payment;
	int			l_Position = 0;
	
	m_Payments.removeAllElements();
	m_PaymentLookup.clear();
	
	if (p_Payments != null)
		{
		for (l_Position = 0; l_Position < p_Payments.length; l_Position++)
			{
			l_Payment = p_Payments [l_Position];
			m_Payments.add(l_Payment);
			m_PaymentLookup.put(l_Payment.getMethod(), l_Position);
			}
		}
	}

//---------------------------------------------------------------------------

public Collection <Payment> getPayments ()
	{
	return m_Payments;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
