/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.search;

import java.awt.Component;
import java.util.Date;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.billing.gui.invoice.InvoiceRenderer;
import lu.tudor.santec.gecamed.billing.gui.invoice.stub.GenericInvoiceStubRenderer;
import lu.tudor.santec.gecamed.core.utils.SSNChecker;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class InvoiceStubRenderer extends GenericInvoiceStubRenderer
	{	
	private JCheckBox	m_Selected;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public InvoiceStubRenderer ()
      {
     super();
 
     m_Selected = new JCheckBox ();
     this.relocalize();       
     }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	JLabel			l_Label;
	Component		l_Component;
	int				l_Column;
	
	l_Label = (JLabel) super.getTableCellRendererComponent(p_Table, p_Value, p_IsSelected, p_HasFocus, p_Row, p_Column);
	l_Component = l_Label;
	
	if ((p_Value != null) && (m_InvoiceStub != null))
		{			
		l_Column = this.modelColumn(p_Table, p_Column);
		
		switch (l_Column)
			{	
			case InvoiceStubListModel.c_TickedColumn :
			
				m_Selected.setSelected((Boolean)p_Value);
				m_Selected.setHorizontalAlignment (SwingConstants.CENTER);
				m_Selected.setBackground(l_Label.getBackground());
				l_Component = m_Selected;
				break;
			
			case InvoiceStubListModel.c_PatientNameColumn :
			case InvoiceStubListModel.c_PhysicianColumn :
				
				l_Label.setHorizontalAlignment (SwingConstants.LEFT);
				l_Label.setText(p_Value.toString());
				break;
				
			case InvoiceStubListModel.c_PatientSSNColumn :
				
				if (m_InvoiceStub.getPatientSSN() != null)
					{
					l_Label.setHorizontalAlignment (SwingConstants.CENTER);
					l_Label.setText(SSNChecker.getFormattedSSN(m_InvoiceStub.getPatientSSN(), false));
					}
				break;
				
			case InvoiceStubListModel.c_InvoiceStatusColumn:
				
				InvoiceRenderer.setStateImageAndToolTip(m_InvoiceStub.getState(), l_Label, m_InvoiceStub.getBalance());
				break;
				
			case InvoiceStubListModel.c_InvoiceDateColumn :
			case InvoiceStubListModel.c_DueDateColumn :
			case InvoiceStubListModel.c_ReminderDateColumn :
			case InvoiceStubListModel.c_InvoicePrintedColumn :
			case InvoiceStubListModel.c_InvoiceClosureDateColumn :
			case InvoiceStubListModel.c_PaymentDateColumn :
				
				l_Label.setText(this.formatDate((Date)p_Value));
				break;
			
			case InvoiceStubListModel.c_AmountColumn 	:
			case InvoiceStubListModel.c_PaymentColumn 	:
			case InvoiceStubListModel.c_DeductionColumn :
			case InvoiceStubListModel.c_BalanceColumn 	:

				l_Label.setHorizontalAlignment (SwingConstants.RIGHT);
				l_Label.setText (this.formatAmount((Double)p_Value));
				break;
				
			default :	
		
				l_Label.setText (p_Value.toString());
				break;
			}
		}		
	
return l_Component;
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
