/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.rate;

import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Rate;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class RateRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              	m_Label;
	private NumberFormat			m_AmountFormat;
	private ImageIcon				m_CheckedIcon;   
	private ImageIcon				m_WarningIcon;   

	private String              	m_CATTip;
	private String              	m_CACTip;
	private String              	m_APCMTip;
	private String              	m_ACMTip;
	
	private Rate					m_Rate;
	private RateListModel			m_TableModel;
	private TableSorter				m_RateSorter;
	private int						m_LastRow;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public RateRenderer ()
      {
      super();

      m_Label = new JLabel ();
      m_Label.setOpaque(true);
      m_Label.setHorizontalAlignment (SwingConstants.CENTER);
       
      m_CheckedIcon = BillingModule.getIconResource ("checked.png");
      m_WarningIcon = BillingModule.getIconResource ("warning.png");
           
      m_AmountFormat = NumberFormat.getInstance();
      m_AmountFormat.setMinimumFractionDigits(2);
      m_AmountFormat.setMaximumFractionDigits(2);
      
      this.relocalize();       
      }

//***************************************************************************
//* Primitives                                       						*
//***************************************************************************

//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_RateSorter != null) && m_RateSorter.isSorting())
		{
		l_ModelRow = m_RateSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
     
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
    m_CATTip		= Translatrix.getTranslationString ("RateRenderer.CATTip");
    m_CACTip		= Translatrix.getTranslationString ("RateRenderer.CACTip");
    m_APCMTip		= Translatrix.getTranslationString ("RateRenderer.APCMTip");
    m_ACMTip		= Translatrix.getTranslationString ("RateRenderer.ACMTip");
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component		l_Component;
	Color			l_Background;
	int				l_Row;
	int				l_Column = -1;
	
	if ((p_Table != null) && (m_TableModel == null)) 
		{
		m_RateSorter 	= (TableSorter) p_Table.getModel();
		m_TableModel 	= (RateListModel) m_RateSorter.getTableModel();
		m_LastRow	  	= -1;
		}

	if ((m_TableModel != null) && (p_Row != m_LastRow))
		{
		l_Row = this.modelRow (p_Row);
		m_Rate = m_TableModel.getRateAt(l_Row);
		m_LastRow = l_Row;
		}

	m_Label.setText("");
	m_Label.setIcon (null);
	m_Label.setToolTipText (null);
	
	if ((p_Value != null) && (m_Rate != null)) 
		{
		l_Column = this.modelColumn(p_Table, p_Column);		
		
		switch (l_Column)
			{
			case RateListModel.c_CATColumn :
	
				if (m_Rate.getCAT()) 
					{
					m_Label.setIcon (m_CheckedIcon);
					m_Label.setToolTipText (m_CATTip);		  
					}
				else m_Label.setIcon (null);
				break;
			
			case RateListModel.c_CACColumn :
			
				if (m_Rate.getCAC()) 
					{
					m_Label.setIcon (m_CheckedIcon);
					m_Label.setToolTipText (m_CACTip);		  
					}
				else m_Label.setIcon (null);
				break;

			case RateListModel.c_APCMColumn :
			
				if (m_Rate.getAPCM()) 
					{
					m_Label.setIcon (m_WarningIcon);
					m_Label.setToolTipText (m_APCMTip);		  
					}
				else m_Label.setIcon (null);
				break;

			case RateListModel.c_ACMColumn :
			
				if (m_Rate.getACM()) 
					{
					m_Label.setIcon (m_WarningIcon);
					m_Label.setToolTipText (m_ACMTip);		  
					}
				else m_Label.setIcon (null);
				break;
		
			case RateListModel.c_AmountColumn :
			
				m_Label.setText (m_AmountFormat.format ((Double)p_Value));
				break;
		
			default:
		
				m_Label.setText (p_Value.toString());
				break;
			}
		}
	
	l_Component = m_Label;
	
	if (p_Table != null) l_Component.setEnabled (p_Table.isEnabled());

	l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
		 							   GECAMedColors.c_EvenLineBackground;

	if ((p_Table != null) && (p_IsSelected)) 
		{
		l_Component.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		l_Component.setBackground(l_Background);
		}

	return l_Component;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
