/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * RateListModel.java
 *
 * Created on June 26, 2006
 */

package lu.tudor.santec.gecamed.billing.gui.rate;

/**
 *
 * @author  santec
 */

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Rate;
import lu.tudor.santec.gecamed.billing.ejb.session.beans.NomenclatureBean;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.NomenclatureInterface;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class RateListModel extends AbstractTableModel
    {
	
	/**
	 * static logger for this class
	 */
	private static Logger m_Logger = Logger.getLogger(RateListModel.class.getName());
	
 	private static final long serialVersionUID = 1L;
  	
    private Vector      	<Rate> m_Rates;

	private NomenclatureInterface m_NomenclatureInterface;

	private HashMap<Integer, KeyValue> m_KeyValueHash;        
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    public static final String c_CodeHeader		 		= "RateListModel.CodeHeader";
    public static final String c_LabelHeader		 	= "RateListModel.LabelHeader";
    public static final String c_CATHeader 				= "RateListModel.CATHeader";
    public static final String c_CACHeader 				= "RateListModel.CACHeader";
    public static final String c_APCMHeader 			= "RateListModel.APCMHeader";
    public static final String c_ACMHeader 				= "RateListModel.ACMHeader";
    public static final String c_AmountHeader 			= "RateListModel.AmountHeader";
          
    public static final int		c_CodeColumn			= 0;
    public static final int		c_LabelColumn			= 1;
    public static final int		c_CATColumn				= 2;
    public static final int		c_CACColumn				= 3;
    public static final int		c_APCMColumn			= 4;
    public static final int		c_ACMColumn				= 5;
    public static final int		c_AmountColumn			= 6;
       
    static final public String c_TableHeaders [] = { 	c_CodeHeader,
    													c_LabelHeader,
    													c_CATHeader,
    													c_CACHeader,
    													c_APCMHeader,
    													c_ACMHeader,
    													c_AmountHeader   };
    
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public RateListModel ()
    {	
    m_Rates= new Vector <Rate> ();
    
    try {
		m_NomenclatureInterface = (NomenclatureInterface) ManagerFactory.getRemote(NomenclatureBean.class);
		Collection<KeyValue> keyVals = m_NomenclatureInterface.getNewestKeyValues();
		m_KeyValueHash = new HashMap<Integer, KeyValue>();
		for (KeyValue keyValue : keyVals) {
			m_KeyValueHash.put(keyValue.getKeyType(), keyValue);
		}
		
		} 
	catch (Exception p_Exception) 
		{
		m_NomenclatureInterface = null;
		m_Logger.warn(p_Exception.getLocalizedMessage());
		}
    
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

	
//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Rates.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    Rate  l_Rate = null;
    
    if ((p_Row >= 0) && (p_Row < m_Rates.size()))
        {
    		l_Rate = m_Rates.elementAt (p_Row);
    		if (l_Rate == null) l_Rate = new Rate ();
        }
    else  l_Rate = new Rate ();
    
    switch (p_Column)
        {
        case  0: return (l_Rate.getCode()  != null) ? l_Rate.getCode() : "";
        case  1: return (l_Rate.getLabel() != null) ? l_Rate.getLabel() : "";       
        case  2: return (l_Rate.getCAT() != null) ? l_Rate.getCAT() : "";
        case  3: return (l_Rate.getCAC() != null) ? l_Rate.getCAC() : "";
        case  4: return (l_Rate.getAPCM() != null) ? l_Rate.getAPCM() : "";
        case  5: return (l_Rate.getACM() != null) ? l_Rate.getACM() : "";
        case  6: return l_Rate.monetize(m_KeyValueHash.get(l_Rate.getKeyType()));
               
        default: return "";
        }
    }
        
//---------------------------------------------------------------------------

public Class getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------
/**
 * queries the ability to be edited of the cell specified by p_Row and p_Column
 * @param p_Row specifies the row to be queried
 * @param p_Column specifies the column to be queried
 * @return <CODE>true</CODE> if the specified cell is editable, <CODE>false</CODE> otherwise
 */
//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
    return false;
    	}
 
//---------------------------------------------------------------------------

public Rate	getRateAt (int p_Row)
    {
    Rate  l_Rate;
     
    if ((p_Row >= 0) && (p_Row < m_Rates.size()))
        {
    		l_Rate = m_Rates.elementAt (p_Row);
        return l_Rate;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void addRate (Rate p_Rate)
    {
    if (p_Rate != null)    
        {    
    		m_Rates.addElement (p_Rate);
    		fireTableChanged(new TableModelEvent(this));
        }
    }
	
//---------------------------------------------------------------------------

public void removeAllRates ()
	{
	int l_LastRow;
	
	l_LastRow = m_Rates.size() -1;
	
	m_Rates.removeAllElements ();
	fireTableChanged(new TableModelEvent(this));
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}

//---------------------------------------------------------------------------

public void removeRateAt (int p_Row)
    {
    if ((p_Row >= 0) && (p_Row < m_Rates.size()))
        {
    	m_Rates.removeElementAt(p_Row);    
    	fireTableRowsDeleted (p_Row,p_Row);
        }
    }

//---------------------------------------------------------------------------

public void setRates (Collection <Rate> p_Rates)
    {
     if (p_Rates == null) return;
        
    this.removeAllRates();
    m_Rates.addAll(p_Rates);
     
    fireTableRowsInserted (0,m_Rates.size());
    }

//---------------------------------------------------------------------------

public Collection <Rate> getRates ()
    {
	HashSet <Rate> l_Rates;
	
	l_Rates = new HashSet <Rate> (m_Rates);
	
	return l_Rates;
    }    
        
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
