/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.print;

import java.util.Comparator;
import java.util.Date;
import java.util.Vector;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Activity;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class ActivityComparator implements Comparator <Activity>
	{
	private Vector<Integer>	m_SortingProperty;
	private Vector<Integer>	m_SortDirection;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants					                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final int	c_Ascending			= 1;
	public static final int	c_Descending		= -1;
	
	public static final int	c_None				= -1;
	
	public static final int	c_Id				= 0;
	public static final int	c_InvoiceId			= 1;
	public static final int	c_PhysicianId		= 2;
	public static final int	c_PatientId			= 3;
	public static final int	c_PatientName		= 4;
	public static final int	c_PatientFirstName	= 5;
	public static final int c_PatientFullName   = 6;
	public static final int	c_PatientSSN		= 7;
	public static final int	c_AccessionNumber	= 8;
	public static final int	c_PerformedDate		= 9;
	public static final int	c_Code				= 10;
	public static final int	c_Quantity			= 11;
	public static final int	c_Coefficient		= 12;
	public static final int	c_KeyValue			= 13;
	public static final int	c_Suffixes			= 14;
	public static final int	c_Majoration		= 15;
	public static final int	c_BaseValue			= 16;
	public static final int	c_MonetaryValue		= 17;
	
	public static final int c_PropertyCount		= 18;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor					                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public ActivityComparator ()
	{
	m_SortingProperty 	= new Vector <Integer> ();
	m_SortDirection 	= new Vector <Integer> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives					                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public int compareStrings (String p_String0, String p_String1)	
	{
	int	l_Comparison = 0;
	
	if ((p_String0 != null) && (p_String1 != null))
		{
		l_Comparison = p_String0.compareToIgnoreCase(p_String1);
		}
	else if ((p_String0 == null) && (p_String1 != null)) l_Comparison = 1;
		 else if ((p_String0 != null) && (p_String1 == null)) l_Comparison = -1;
	 		
	return l_Comparison;
	}

//---------------------------------------------------------------------------

public int compareDates (Date p_Date0, Date p_Date1)	
	{
	int	l_Comparison = 0;
	
	if ((p_Date0 != null) && (p_Date1 != null))
		{
		l_Comparison = p_Date0.compareTo(p_Date1);
		}
	else if ((p_Date0 == null) && (p_Date1 != null)) l_Comparison = 1;
		else if ((p_Date0 != null) && (p_Date1 == null)) l_Comparison = -1;
			
	return l_Comparison;
	}

//---------------------------------------------------------------------------

public int compareIntegers (Integer p_Integer0, Integer p_Integer1)	
	{
	int	l_Comparison = 0;
	
	if ((p_Integer0 != null) && (p_Integer1 != null))
		{
		l_Comparison = p_Integer0.compareTo(p_Integer1);
		}
	else if ((p_Integer0 == null) && (p_Integer1 != null)) l_Comparison = 1;
	else if ((p_Integer0 != null) && (p_Integer1 == null)) l_Comparison = -1;
			
	return l_Comparison;
	}
//---------------------------------------------------------------------------

public int compareFloats (Float p_Float0, Float p_Float1)	
	{
	int	l_Comparison = 0;
	
	if ((p_Float0 != null) && (p_Float1 != null))
		{
		l_Comparison = p_Float0.compareTo(p_Float1);
		}
	else if ((p_Float0 == null) && (p_Float1 != null)) l_Comparison = 1;
	else if ((p_Float0 != null) && (p_Float1 == null)) l_Comparison = -1;
			
	return l_Comparison;
	}

//---------------------------------------------------------------------------

public int compareDoubles (Double p_Double0, Double p_Double1)	
	{
	int	l_Comparison = 0;
	
	if ((p_Double0 != null) && (p_Double1 != null))
		{
		l_Comparison = p_Double0.compareTo(p_Double1);
		}
	else if ((p_Double0 == null) && (p_Double1 != null)) l_Comparison = 1;
	else if ((p_Double0 != null) && (p_Double1 == null)) l_Comparison = -1;
			
	return l_Comparison;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body					                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void addSortCriterion (int p_Property, int p_Direction)
	{
	int l_Direction;
	
	if ((p_Property >= 0) && (p_Property < c_PropertyCount))
		{
		l_Direction = (p_Direction > 0)?c_Ascending:c_Descending;
		
		m_SortingProperty.add (p_Property);
		m_SortDirection.add (l_Direction);	
		}
	}

//---------------------------------------------------------------------------

	
public int compare (Activity p_Activity0, Activity p_Activity1) 
	{
	int	l_CriterionIndex	= 0;
	int	l_Criterion			= 0;
	int	l_Direction			= 0;
	int	l_Comparison		= 0;
	
	while ((l_CriterionIndex < m_SortingProperty.size()) && (l_Comparison == 0))
		{
		l_Criterion = m_SortingProperty.elementAt(l_CriterionIndex);
		l_Direction = m_SortDirection.elementAt(l_CriterionIndex);
		
		if ((p_Activity0 == null) && (p_Activity1 != null)) return 1 * l_Direction;
		else if ((p_Activity0 != null) && (p_Activity1 == null)) return -1 * l_Direction;
		else if ((p_Activity0 == null) && (p_Activity1 == null)) return 0;
		
		switch (l_Criterion)
			{
			case c_Id:
				
				l_Comparison = this.compareIntegers (p_Activity0.getId(), p_Activity1.getId());
				break;
			
			case c_InvoiceId:
				
				l_Comparison = this.compareIntegers (p_Activity0.getPhysicianId(), p_Activity1.getPhysicianId());
				break;
			
			case c_PatientId:
				
				l_Comparison = this.compareIntegers (p_Activity0.getPatientId(), p_Activity1.getPatientId());
				break;
			
			case c_PhysicianId:
				
				l_Comparison = this.compareIntegers (p_Activity0.getPhysicianId(), p_Activity1.getPhysicianId());
				break;
			
			case c_PatientName:
				
				l_Comparison = this.compareStrings (p_Activity0.getPatientName(), p_Activity1.getPatientName());
				break;
			
			case c_PatientFirstName:
				
				l_Comparison = this.compareStrings (p_Activity0.getPatientFirstName(), p_Activity1.getPatientFirstName());
				break;
			
			case c_PatientFullName:
				
				l_Comparison = this.compareStrings (p_Activity0.getPatientFullName(), p_Activity1.getPatientFullName());
				break;

			case c_PatientSSN:
				
				l_Comparison = this.compareStrings (p_Activity0.getPatientSSN(), p_Activity1.getPatientSSN());
				break;
			
			case c_AccessionNumber:
				
				l_Comparison = this.compareStrings (p_Activity0.getAccessionNumber(), p_Activity1.getAccessionNumber());
				break;
			
			case c_PerformedDate:
				
				l_Comparison = this.compareDates (p_Activity0.getPerformedDate(), p_Activity1.getPerformedDate());
				break;
			
			case c_Code:
				
				l_Comparison = this.compareStrings (p_Activity0.getCode(), p_Activity1.getCode());
				break;
			
			case c_Quantity:
				
				l_Comparison = this.compareIntegers (p_Activity0.getQuantity(), p_Activity1.getQuantity());
				break;
			
			case c_Coefficient:
				
				l_Comparison = this.compareDoubles (p_Activity0.getCoefficient(), p_Activity1.getCoefficient());
				break;
			
			case c_KeyValue:
				
				l_Comparison = this.compareDoubles (p_Activity0.getKeyValue(), p_Activity1.getKeyValue());
				break;
			
			case c_Suffixes:
				
				l_Comparison = this.compareStrings (p_Activity0.getSuffixes(), p_Activity1.getSuffixes());
				break;
			
			case c_Majoration:
				
				l_Comparison = this.compareDoubles (p_Activity0.getMajoration(), p_Activity1.getMajoration());
				break;
			
			case c_BaseValue:
				
				l_Comparison = this.compareDoubles (p_Activity0.getBaseValue(), p_Activity1.getBaseValue());
				break;
			
			case c_MonetaryValue:
				
				l_Comparison = this.compareDoubles (p_Activity0.getMonetaryValue(), p_Activity1.getMonetaryValue());
				break;
			}
		
			l_Comparison *= l_Direction;
			l_CriterionIndex++;
		}
	
	return l_Comparison;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
}
