/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.memo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ScrollPaneConstants;
import javax.swing.WindowConstants;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.htmleditor.HTMLEditor;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class MemoEditorField extends AbstractCellEditor implements TableCellEditor,
                                    							   ActionListener,
                                    							   Relocalizable
{
    private	JButton 		m_StartEditingButton;
    private	JButton		m_OkayButton;
    private	JButton		m_CancelButton;
    private  JDialog 		m_EditorDialog;
    private  HTMLEditor	m_HTMLEditor;
    private	String		m_Note;
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    private final static Dimension c_PreferredSize = new Dimension (600,400);
    
    protected static final String EDIT = "edit";

    private final static String c_Columns	= 	"3dlu,fill:pref:grow," +
	  										"3dlu,fill:max(30dlu;pref)," +
	  										"3dlu,fill:max(30dlu;pref),3dlu";
 
    private final static String c_Rows		= 	"3dlu,fill:pref:grow," +
	  										"3dlu,fill:pref,3dlu";

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

    public MemoEditorField() 
    		{
    		CellConstraints	l_Constraints;
    		FormLayout		l_Layout;
    		JScrollPane		l_Scroller;
    		
    		l_Scroller = new JScrollPane();
    		l_Scroller.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
    		
    		l_Constraints  = new CellConstraints();
    		l_Layout = new FormLayout(c_Columns, c_Rows);

    		m_HTMLEditor = new HTMLEditor ();
     	l_Scroller.setViewportView (m_HTMLEditor);
    		
    		m_EditorDialog = new JDialog(MainFrame.getInstance());
    		m_EditorDialog.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    		m_EditorDialog.setTitle(Translatrix.getTranslationString("MemoEditorField.Title"));
    		m_EditorDialog.setLayout(l_Layout);
    		
    		m_EditorDialog.add (l_Scroller, l_Constraints.xywh(2, 2, 5, 1));
     	
    		m_OkayButton = new JButton (Translatrix.getTranslationString("core.ok"));
    		m_OkayButton.addActionListener(this);
    		
    		m_CancelButton = new JButton (Translatrix.getTranslationString("core.cancel"));
    		m_CancelButton.addActionListener(this);
    		
    		m_EditorDialog.add (m_OkayButton, l_Constraints.xywh(4, 4, 1, 1));
    		m_EditorDialog.add (m_CancelButton, l_Constraints.xywh(6, 4, 1, 1));
   		
    		m_StartEditingButton = new JButton();
    		//m_StartEditingButton.setActionCommand(EDIT);
    		m_StartEditingButton.addActionListener(this);
    		m_StartEditingButton.setBorderPainted(false);
       	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_ActionEvent) 
    		{
        if (p_ActionEvent.getSource() == m_StartEditingButton) 
        		{
        		m_HTMLEditor.setText(m_Note);
        		m_HTMLEditor.setPreferredSize(c_PreferredSize);
        		m_EditorDialog.pack();
        		MainFrame.showDialogCentered(m_EditorDialog);
        		} 
        else if (p_ActionEvent.getSource() == m_OkayButton)
        		{
        		m_EditorDialog.setVisible(false);
        		m_Note = m_HTMLEditor.getText();        	
        		fireEditingStopped();
        		}
        else if (p_ActionEvent.getSource() == m_CancelButton)
			{
        		m_EditorDialog.setVisible(false);
        		fireEditingCanceled();
			}
    		}

//---------------------------------------------------------------------------

//Implement the one CellEditor method that AbstractCellEditor doesn't.
    public Object getCellEditorValue() {
    return 	m_Note;
    }

//  ---------------------------------------------------------------------------

    //Implement the one method defined by TableCellEditor.
    public Component getTableCellEditorComponent(JTable table,
                                                 Object value,
                                                 boolean isSelected,
                                                 int row,
                                                 int column) {
    	m_Note = (String)value;
    	m_StartEditingButton.setText(m_Note);
    	m_StartEditingButton.doClick();
    	return m_StartEditingButton;
    }

//---------------------------------------------------------------------------

public void relocalize() 
	{
	if (m_EditorDialog != null)
		m_EditorDialog.setTitle(Translatrix.getTranslationString("MemoEditorField.Title"));
	
	if (m_OkayButton != null)
		m_OkayButton.setText (Translatrix.getTranslationString("core.ok"));
	
	if (m_CancelButton != null)
		m_CancelButton.setText (Translatrix.getTranslationString("core.cancel"));
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
