/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.medpres;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.HashMap;

import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.dicom.gui.AutoCompletion;
import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedMessage;
import lu.tudor.santec.gecamed.core.gui.GECAMedMessageListener;
import lu.tudor.santec.gecamed.core.gui.RegistrationDesk;

/**
 * @author 
 * 
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class MedPresCellEditor extends AbstractCellEditor implements TableCellEditor, TableCellRenderer, KeyListener, GECAMedMessageListener
																   
    {
	private JLabel renderLabel = new JLabel();
    private JComboBox<Object> m_ComboBox; 
    private HashMap<String, MedPres> medHash = new HashMap<String, MedPres>();
	
	private static final long serialVersionUID = 1L;
	private static final String NO_MED = "---";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public MedPresCellEditor() 
    {
	super ();
	renderLabel.setOpaque(true);
	m_ComboBox = new JComboBox<Object>();
	updateMedPres();
	AutoCompletion.enableWithFreeText(m_ComboBox);
	m_ComboBox.addKeyListener (this);
	m_ComboBox.setRenderer(new DefaultListCellRenderer() {
		private static final long serialVersionUID = 1L;
		public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
			JComponent c =  (JComponent) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
			if (value instanceof MedPres) {
				MedPres m = (MedPres) value;
				renderLabel.setToolTipText("<html>"+ m.getName() + "<br>" + m.getUcm());
			} else {
				renderLabel.setToolTipText(null);
			}
			return c;
		}	
	});
	RegistrationDesk.addGECAMedMessageListener(this);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

private void updateMedPres() {
	Collection<Contact> medPres = BillingModule.getInstance().prefetchMedPres();
	m_ComboBox.removeAllItems();
	medHash.clear();
	m_ComboBox.addItem(NO_MED);
	for (Contact contact : medPres) {
		MedPres mp = new MedPres(contact);
		medHash.put(mp.getUcm(), mp);
		m_ComboBox.addItem(mp);
	}
}

public Object getCellEditorValue() 
	{
	Object val = m_ComboBox.getSelectedItem();
	if (val instanceof MedPres) {
		return ((MedPres)val).getUcm();
	} else if (NO_MED.equals(val)) {
		return "";
	} else  {
		return val +"";
	}
	}

//---------------------------------------------------------------------------

	public Component getTableCellEditorComponent(JTable p_Table, Object p_Value, boolean p_IsSelected, int p_Row, int p_Column) {
		if (p_Value instanceof String) {
			MedPres m = medHash.get(p_Value);
			if (m != null) {
				m_ComboBox.setSelectedItem(m);
			} else if (p_Value == null || ((String)p_Value).trim().length() == 0) {
				m_ComboBox.setSelectedItem(NO_MED);
			} else {
				m_ComboBox.setSelectedItem((String) p_Value);
			}
		} else {
			m_ComboBox.setSelectedItem(NO_MED);
		}

		return m_ComboBox;
	}

//---------------------------------------------------------------------------

	public Component getTableCellRendererComponent(JTable p_Table, Object p_Value, boolean p_IsSelected, boolean p_HasFocus, int p_Row, int p_Column) {

		if (p_Value instanceof String) {
			MedPres m = medHash.get(p_Value);
			if (m != null) {
				renderLabel.setText(m.getShortCut());
				renderLabel.setToolTipText("<html>"+ m.getName() + "<br>" + m.getUcm());
			} else {
				renderLabel.setText((String) p_Value);
				renderLabel.setToolTipText(null);
			}
		}
		
		Color l_Background = null;
		if ((p_Table != null) && (p_IsSelected)) 
			l_Background = p_Table.getSelectionBackground();
		else 
			l_Background = (p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : GECAMedColors.c_EvenLineBackground;
		renderLabel.setBackground(l_Background);

		return renderLabel;
	}

//---------------------------------------------------------------------------

public void keyPressed(KeyEvent p_Event)
	{
	if (	(p_Event.getKeyCode() == KeyEvent.VK_TAB)
		 || (p_Event.getKeyCode() == KeyEvent.VK_ENTER))
		{
		this.stopCellEditing();
		}
	else if ((p_Event.getKeyCode() == KeyEvent.VK_ESCAPE))
		{
		this.cancelCellEditing();
		}
	}

//---------------------------------------------------------------------------

public void keyReleased(KeyEvent p_Event)
	{
	}

//---------------------------------------------------------------------------

public void keyTyped(KeyEvent p_Event)
	{
	}

public void handleGECAMedMessage(GECAMedMessage message) {
	if (MedPres.MEDPRES_CHANGED.equals(message.getMessage())) {
		updateMedPres();
	}
}

public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
	// TODO Auto-generated method stub
	return null;
}


//***************************************************************************
//* Class Body                                                              *
//***************************************************************************


//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}



