/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.ledger;


import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Ledger;
import lu.tudor.santec.gecamed.billing.gui.invoice.InvoiceListModel;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class LedgerRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              	m_Label;
	private SimpleDateFormat		m_DateFormat;
	private SimpleDateFormat		m_DateTimeFormat;
	private NumberFormat			m_AmountFormat;
	
	private LedgerListModel			m_TableModel;
	private TableSorter				m_LedgerSorter;   
	private Ledger					m_Ledger;
 
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
    	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public LedgerRenderer ()
      {
      super();

      m_Label = new JLabel ();
      m_Label.setOpaque(true);
      m_Label.setHorizontalAlignment (SwingConstants.CENTER);
 	  m_Label.setToolTipText (null);
	  m_Label.setIcon (null);
     
//      m_AmountFormat = NumberFormat.getInstance();
//      m_AmountFormat.setMinimumFractionDigits(2);
//      m_AmountFormat.setMaximumFractionDigits(2);
//      m_AmountFormat.setCurrency(Currency.getInstance ("EUR"));
       
      this.relocalize();       
      }

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_LedgerSorter != null) && m_LedgerSorter.isSorting())
		{
		l_ModelRow = m_LedgerSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//---------------------------------------------------------------------------

private String formatAmount (Double p_Amount)
	{
	p_Amount = Ledger.round (p_Amount);
	
	if (p_Amount == 0d)
		 return "";
	else return m_AmountFormat.format (p_Amount);
	}
//---------------------------------------------------------------------------

private String formatDate (Date p_Date)
	{
	if (p_Date.equals (InvoiceListModel.c_Epoch))
		 return "";
	else return m_DateFormat.format (p_Date);
	}

//---------------------------------------------------------------------------

private String formatDateTime (Date p_Date)
	{
	if (p_Date.equals (InvoiceListModel.c_Epoch))
		 return "";
	else return m_DateTimeFormat.format (p_Date);
	}


//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
     
//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
    Locale  l_Locale;
    	  	
    l_Locale = Translatrix.getLocale ();
    	  	
    if (l_Locale != null)
    	{
        m_DateFormat = new SimpleDateFormat ("d MMMM yyyy",l_Locale);
        m_DateTimeFormat = new SimpleDateFormat ("d MMMM yyyy HH:mm",l_Locale);
     	}
    else 
    	{
    	m_DateFormat = new SimpleDateFormat ("d MMMM yyyy");   
    	m_DateTimeFormat = new SimpleDateFormat ("d MMMM yyyy HH:mm");   
    	}
	
//    m_AmountFormat = NumberFormat.getCurrencyInstance (Translatrix.getLocale());
    m_AmountFormat = NumberFormat.getCurrencyInstance (Locale.FRANCE);
    m_AmountFormat.setCurrency(Currency.getInstance ("EUR"));
 	}
    

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component		l_Component		= null;
	Color			l_Background;
//	int				l_Row;
	int				l_Column		= -1;
	
	l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_EvenLineBackground : 
		 							 GECAMedColors.c_OddLineBackground;

	if (p_Value != null)
		{
		m_Label.setText (null);
		l_Column = this.modelColumn(p_Table, p_Column);
	
		switch (l_Column)
			{
			case LedgerListModel.c_SettlementDateColumn :
					
				m_Label.setText (this.formatDate ((Date)p_Value));				
				m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Component = m_Label;
				break;
				
			case LedgerListModel.c_TransactionDateColumn :
					
				m_Label.setText (this.formatDateTime ((Date)p_Value));				
				m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Component = m_Label;
				break;
				
			case LedgerListModel.c_DebitColumn :
		
				m_Label.setText (this.formatAmount ((Double)p_Value));
				m_Label.setHorizontalAlignment (SwingConstants.RIGHT);
				l_Component = m_Label;
				
				l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedEvenLineBackground : 
		 							 			   GECAMedColors.c_RedOddLineBackground;

				break;
	
			case LedgerListModel.c_CreditColumn :
		
				m_Label.setText (this.formatAmount ((Double)p_Value));
				m_Label.setHorizontalAlignment (SwingConstants.RIGHT);
				l_Component = m_Label;

				l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_GreenEvenLineBackground : 
		 							 			   GECAMedColors.c_GreenOddLineBackground;

				break;
			
			default:

				m_Label.setText (p_Value.toString());
				m_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Component = m_Label;
				break;
			}
		}
		
	if (l_Component == null) return l_Component;
	
	if (p_Table != null) l_Component.setEnabled (p_Table.isEnabled());

	if ((p_Table != null) && (p_IsSelected)) 
		{
		l_Component.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		l_Component.setBackground(l_Background);
		}

	return l_Component;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}

