/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.ledger;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;

import javax.swing.JButton;
import javax.swing.JDialog;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Ledger;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class LedgerDialog extends JDialog implements ActionListener,
													 Relocalizable
{											
	private LedgerListBox	m_Ledgers;
	private JButton			m_OkayButton;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private final static String c_Columns		= 		"3dlu,fill:max(220dlu;pref):grow," +
														"3dlu,fill:max(50dlu;pref),3dlu";
														
	private final static String c_Rows			=    	"3dlu,fill:pref:grow," + 
										 				"3dlu,fill:pref,3dlu";
	
	private final static String	c_Title			= "LedgerDialog.Title";
	
//***************************************************************************
//* Constructor                                                             *
//***************************************************************************

public LedgerDialog (String invoiceNumber)
	{
	
	super (MainFrame.getInstance(),Translatrix.getTranslationString(c_Title) + " " + invoiceNumber,true);
    
	CellConstraints	l_Constraints;
    FormLayout		l_Layout;
	
	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);

	m_Ledgers = new LedgerListBox ();
 	m_Ledgers.getViewport().setOpaque(false);
  	m_Ledgers.setBackground(GECAMedColors.c_ScrollPaneBackground);
	m_Ledgers.setPreferredSize(new Dimension (100,100));
  	
	m_OkayButton   = new JButton ();
	m_OkayButton.setText(Translatrix.getTranslationString("core.ok"));
	m_OkayButton.setIcon(GECAMedModule.getSmallIcon (GECAMedIconNames.OK));
	m_OkayButton.addActionListener(this);

	l_Layout = new FormLayout(c_Columns, c_Rows);
    this.setLayout (l_Layout);
	
    l_Constraints = new CellConstraints();
    
    this.add (m_Ledgers,    l_Constraints.xywh(2, 2, 3, 1));
    this.add (m_OkayButton, l_Constraints.xywh(4, 4, 1, 1));
	}
	
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent p_Event) 
	{
	if (p_Event.getSource().equals(m_OkayButton))
		this.setVisible(false);
	}

//---------------------------------------------------------------------------

public void setLedgers (Collection <Ledger> p_Ledgers)
	{
	m_Ledgers.setLedgers(p_Ledgers);
	m_Ledgers.packColumns ();
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	if (m_Ledgers != null) m_Ledgers.relocalize();
	
	if (m_OkayButton != null)
		m_OkayButton.setText(Translatrix.getTranslationString("core.ok"));
	}

//---------------------------------------------------------------------------	
//***************************************************************************
//* End of Class				                            				*
//***************************************************************************
//---------------------------------------------------------------------------	

}
