package lu.tudor.santec.gecamed.billing.gui.invoice.stub;

import java.util.ArrayList;
import java.util.Collection;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
import lu.tudor.santec.gecamed.billing.ejb.session.beans.InvoiceBean;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.InvoiceInterface;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;

import org.apache.log4j.Logger;

public class InvoiceStubUtils 
	{
	private InvoiceInterface	m_InvoiceInterface;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	private static Logger m_Logger = Logger.getLogger (InvoiceStubUtils.class.getName());

	private static final Collection <Integer> m_Dependencies = new ArrayList <Integer> ();
    
	static 	{
    		m_Dependencies.add(InvoiceInterface.c_PatientDependency);
    		m_Dependencies.add(InvoiceInterface.c_HospitalisationDependency);
    		m_Dependencies.add(InvoiceInterface.c_CloserDependency);
    		m_Dependencies.add(InvoiceInterface.c_ModifierDependency);
	    	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public InvoiceStubUtils ()
	{
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private InvoiceInterface getInvoiceInterface ()
	{
	if (m_InvoiceInterface != null) return m_InvoiceInterface;

	try {
		m_InvoiceInterface = (InvoiceInterface) ManagerFactory.getRemote(InvoiceBean.class);
		} 
	catch (Exception p_Exception) 
		{
		m_Logger.warn(p_Exception.getLocalizedMessage());
		}

	return m_InvoiceInterface;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Fetches the Invoice corresponding to the specified InvoiceStub.
 * @param p_InvoiceStub specifies the InvoiceStub to get the corresponding
 * invoice for.
 * @param p_Dependencies specifies the lazy dependencies that ought to be
 * fetched together with the invoice. Collection may hold dependency identifiers
 * defined in InvoiceInterface. Specifying <code>null</code> will fetch invoice
 * without dependencies
 * @return The invoice matching the specified invoice stub together with the
 * specified, if any, lazy dependencies initialized.
 */
//---------------------------------------------------------------------------

public Invoice fetchInvoiceForStub (InvoiceStub p_InvoiceStub, Collection <Integer> p_Dependencies)
	{
	Invoice	l_Invoice = null;

	InvoiceInterface	l_InvoiceInterface;

	l_InvoiceInterface = this.getInvoiceInterface();
	if (l_InvoiceInterface == null) return l_Invoice;

	try	{
		l_Invoice = l_InvoiceInterface.getInvoiceByID (p_InvoiceStub.getId());
		if (p_Dependencies != null) l_Invoice = l_InvoiceInterface.fetchLazyDependencies (l_Invoice, p_Dependencies);
		}
	catch (Exception p_Exception)
		{
		m_Logger.warn(p_Exception.getLocalizedMessage());
		}

	return l_Invoice;
	}

//---------------------------------------------------------------------------
/**
 * Fetches the Invoice corresponding to the specified InvoiceStub.
 * @param p_InvoiceStub specifies the InvoiceStub to get the corresponding
 * invoice for.
 * @param p_WithDependencies specifies whether or not, lazy dependencies of
 * fetched invoice ought to be fetched as well or not.
 * @return The invoice matching the specified invoice stub together with or without,
 * depending on p_WithDependencies parameter, lazy dependencies initialized.
 */
//---------------------------------------------------------------------------

public Invoice fetchInvoiceForStub (InvoiceStub p_InvoiceStub, boolean p_WithDependencies)
	{
	Invoice	l_Invoice = null;

	InvoiceInterface	l_InvoiceInterface;

	l_InvoiceInterface = this.getInvoiceInterface();
	if (l_InvoiceInterface == null) return l_Invoice;

	try	{
		l_Invoice = l_InvoiceInterface.getInvoiceByID (p_InvoiceStub.getId());
		if (p_WithDependencies) l_Invoice = l_InvoiceInterface.fetchLazyDependencies(l_Invoice, m_Dependencies);
		}
	catch (Exception p_Exception)
		{
		m_Logger.warn(p_Exception.getLocalizedMessage());
		}

	return l_Invoice;
	}

//---------------------------------------------------------------------------

public Invoice saveInvoice (Invoice p_Invoice)
	{
	InvoiceInterface	l_InvoiceInterface;

	l_InvoiceInterface = this.getInvoiceInterface();
	if (l_InvoiceInterface == null) return p_Invoice;

	try	{
		p_Invoice = l_InvoiceInterface.saveInvoice(p_Invoice);
		}
	catch (Exception p_Exception)
		{
		m_Logger.warn(p_Exception.getLocalizedMessage());
		}

	return p_Invoice;	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
}
