/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.invoice.stub;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.utils.InvoiceWorkflow;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;
import lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader.SearchTableHeader;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class GenericInvoiceStubRenderer extends DefaultTableCellRenderer implements Relocalizable 
	{
	private JLabel              			m_Label;
	private DateFormat    					m_DateFormat;
	
	private ImageIcon						m_OpenState;
	private ImageIcon						m_VerifiedState;
	private ImageIcon						m_ClosedState;
	private ImageIcon						m_PrintedState;
	private ImageIcon						m_ReminderState;
	private ImageIcon						m_PaidState;
	private ImageIcon						m_PartPaidState;
	private ImageIcon						m_CanceledState;
	
	private NumberFormat					m_CurrencyFormat;
	private TableSorter						m_InvoiceSorter;
	private SearchTableHeader				m_SearchHeader;
	
	protected GenericInvoiceStubListInterface	m_TableModel;
	protected InvoiceStub					m_InvoiceStub;
	protected Date							m_Today;
	protected boolean						m_IsAlarm;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
	
	private static final Double c_Zero			= Double.valueOf (0);
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public GenericInvoiceStubRenderer ()
      {
     super();

     GregorianCalendar	l_EarliestToday;
      
     m_Label = new JLabel ();
     m_Label.setOpaque(true);
     m_Label.setHorizontalAlignment (SwingConstants.CENTER);
       
     m_OpenState     = BillingModule.getIconResource("invoice_open_state.png");
     m_VerifiedState = BillingModule.getIconResource("invoice_verified_state.png");
     m_ClosedState   = BillingModule.getIconResource("invoice_closed_state.png");
     m_PrintedState  = BillingModule.getIconResource("invoice_printed_state.png");
     m_ReminderState = BillingModule.getIconResource("invoice_reminded_state.png");
     m_PaidState     = BillingModule.getIconResource("invoice_paid_state.png");
     m_PartPaidState = BillingModule.getIconResource("invoice_partpaid_state.png");
     m_CanceledState = BillingModule.getIconResource("invoice_canceled_state.png");
    
     m_TableModel 		= null;
     m_InvoiceStub      = null;
      
     l_EarliestToday = new GregorianCalendar();
     l_EarliestToday.setTime (new Date ());
     l_EarliestToday.set(Calendar.HOUR_OF_DAY,0);
     l_EarliestToday.set(Calendar.MINUTE,0);
     l_EarliestToday.set(Calendar.SECOND,0);
     l_EarliestToday.set(Calendar.MILLISECOND,0);
	
     m_Today = l_EarliestToday.getTime();
     
     this.relocalize();       
     }

//***************************************************************************
//* Class Primitives		                                                  *
//***************************************************************************
//---------------------------------------------------------------------------

public void formatState (Invoice p_Invoice)
	{
	String	l_InvoiceStateName;
	
	l_InvoiceStateName = InvoiceWorkflow.getInvoiceStateName(p_Invoice);
	
	switch (p_Invoice.getState())
		{
		case InvoiceWorkflow.c_NewState:
		case InvoiceWorkflow.c_OpenState: 		m_Label.setIcon(m_OpenState);
												break;
		case InvoiceWorkflow.c_VerifiedState: 	m_Label.setIcon(m_VerifiedState);
												break;
		case InvoiceWorkflow.c_ClosedState: 	m_Label.setIcon(m_ClosedState);
												break;
		case InvoiceWorkflow.c_PrintedState:	m_Label.setIcon(m_PrintedState);
												break;	
		case InvoiceWorkflow.c_RemindedState:	m_Label.setIcon(m_ReminderState);
												break;
		case InvoiceWorkflow.c_PaidState:
												if (p_Invoice.getBalance() == 0) {
													m_Label.setIcon(m_PaidState);	
												} else {
													m_Label.setIcon(m_PartPaidState);													
												}
												break;
		case InvoiceWorkflow.c_CanceledState:	m_Label.setIcon(m_CanceledState);
												break;				
		}

	m_Label.setToolTipText (Translatrix.getTranslationString("GenericInvoiceRenderer." + l_InvoiceStateName));	
	}

//---------------------------------------------------------------------------

public String formatDate (Date p_Date)
	{
	if (p_Date.equals (GenericInvoiceStubListInterface.c_Epoch))
		 return "";
	else return m_DateFormat.format (p_Date);
	}

//---------------------------------------------------------------------------

public String formatAmount (Double p_Amount)
	{
	if (p_Amount != null)
		 return m_CurrencyFormat.format (p_Amount);
	else return m_CurrencyFormat.format(c_Zero);
	}

//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_InvoiceSorter != null) && m_InvoiceSorter.isSorting())
		{
		l_ModelRow = m_InvoiceSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_Table == null) return -1;
	
	if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//---------------------------------------------------------------------------

private Color getBackground (int p_Row, int p_Column)
	{
	Color l_Background = Color.WHITE;
	
	if (!m_IsAlarm)
		{
		if ((m_SearchHeader != null) && (m_SearchHeader.isSearchColumn(p_Column)))
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineSearchBackground : 
			 							   	   GECAMedColors.c_EvenLineSearchBackground;
			}
		else
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
									 	   	   GECAMedColors.c_EvenLineBackground;
//			l_Background = ( p_Row % 2 == 0) ? new Color(215,238,255) : 
//	 	   	   								   new Color(255,255,255);
			}
		}
	else
		{
		if ((m_SearchHeader != null) && (m_SearchHeader.isSearchColumn(p_Column)))
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedOddLineSearchBackground : 
		 						     	   	   GECAMedColors.c_RedEvenLineSearchBackground;
			}
		else
			{
			l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedOddLineBackground : 
	     	   							       GECAMedColors.c_RedEvenLineBackground;
//			l_Background = ( p_Row % 2 == 0) ? new Color(255,200,200) : 
//			       							   new Color(255,224,224);
			}
		}

	return l_Background;
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void setSearchHeader (SearchTableHeader p_SearchHeader)
	{
	m_SearchHeader = p_SearchHeader;
	}

//---------------------------------------------------------------------------
/**
 * Method is part of the Relocalizable interface. The method does everything
 * required to reflect changes of active Locale
 */
//---------------------------------------------------------------------------

public void relocalize() 
	{
    Locale  l_Locale;
    	  	
    l_Locale = Translatrix.getLocale ();
    	  	
//    if (l_Locale != null) 
//         m_DateFormat = new SimpleDateFormat ("d MMMM yyyy",l_Locale);
//    else m_DateFormat = new SimpleDateFormat ("d MMMM yyyy");   
    m_DateFormat = GECAMedGuiUtils.getDateFormat(false);
    
//    m_CurrencyFormat = NumberFormat.getCurrencyInstance (Translatrix.getLocale());
    m_CurrencyFormat = NumberFormat.getCurrencyInstance (Locale.FRANCE);
    m_CurrencyFormat.setCurrency(Currency.getInstance ("EUR"));
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Color			l_Background;
	int				l_Row;
	int				l_Column = -1;

	if ((p_Table != null) && (m_TableModel == null)) 
		{
		m_InvoiceSorter = (TableSorter) p_Table.getModel();
		m_TableModel 	= (GenericInvoiceStubListInterface) m_InvoiceSorter.getTableModel();
		}
	
	if (m_TableModel != null)
		{
		l_Row = this.modelRow (p_Row);
		m_InvoiceStub = m_TableModel.getInvoiceStubAt (l_Row);
		if ((m_InvoiceStub != null) && (m_InvoiceStub.getDueDate() != null))
			{
			m_IsAlarm = m_InvoiceStub.isExpired();
			}
		}
	
	m_Label.setIcon (null);
	m_Label.setToolTipText (null);
	m_Label.setText ("");
	m_Label.setHorizontalAlignment (SwingConstants.CENTER);
	m_Label.setForeground (Color.BLACK);

	if (p_Table != null) 
		{
		m_Label.setEnabled (p_Table.isEnabled());
		l_Column = this.modelColumn(p_Table, p_Column);
		}
		
	l_Background = this.getBackground(p_Row, l_Column);
	
	if ((p_Table != null) && (p_IsSelected)) 
		{
		m_Label.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		m_Label.setBackground(l_Background);
		}

return m_Label;
}


public static void main(String[] args) {
	 JColorChooser.showDialog(new JFrame(""), "", Color.WHITE);
}
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
