//package lu.tudor.santec.gecamed.billing.gui.invoice.stub;
//
///*******************************************************************************
// * This file is part of GECAMed.
// * 
// * GECAMed is free software: you can redistribute it and/or modify
// * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
// * the Free Software Foundation, either version 3 of the License, or
// * (at your option) any later version.
// * 
// * GECAMed is distributed in the hope that it will be useful,
// * but WITHOUT ANY WARRANTY; without even the implied warranty of
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// * GNU Lesser General Public License for more details.
// * 
// * You should have received a copy of the GNU Lesser General Public License (L-GPL)
// * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
// * 
// * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
// * (c) CRP Henri Tudor, Luxembourg, 2008
// *******************************************************************************/
///*
// * InvoiceListModel.java
// *
// * Created on March 31, 2006
// */
//
///**
// *
// * @author  santec
// */
//
//import java.util.ArrayList;
//import java.util.Collection;
//import java.util.Date;
//import java.util.Hashtable;
//import java.util.Iterator;
//import java.util.Vector;
//
//import javax.swing.table.AbstractTableModel;
//
//import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
//import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
//import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
//import lu.tudor.santec.i18n.Translatrix;
//
////***************************************************************************
////* Class Members                                                           *
////***************************************************************************
//
//public class GenericInvoiceStubListModel extends AbstractTableModel implements GenericInvoiceStubListInterface
//    {
// 	private static final long serialVersionUID = 1L;
//	
//    private Vector    <InvoiceStub> 	m_InvoiceStubs;        
//    private Hashtable <Integer,Integer>	m_InvoiceStubLookup;
//    
//    public static final Date c_Epoch = new Date (0);
//    
////***************************************************************************
////* Class Constants                                                         *
////***************************************************************************
//
//    public static final String c_TickedHeader				= "InvoiceListModel.TickedHeader";
//    public static final String c_PatientNameHeader			= "InvoiceListModel.PatientNameHeader";
//    public static final String c_PatientSSNHeader			= "InvoiceListModel.PatientSSNHeader";
//    public static final String c_InvoiceNumberHeader 		= "InvoiceListModel.InvoiceNumberHeader";
//    public static final String c_InvoiceDateHeader 			= "InvoiceListModel.InvoiceDateHeader";
//    public static final String c_DueDateHeader 				= "InvoiceListModel.DueDateHeader";
//    public static final String c_ReminderDateHeader 		= "InvoiceListModel.ReminderDateHeader";
//    public static final String c_AmountHeader 				= "InvoiceListModel.AmountHeader";
//    public static final String c_PaymentHeader 				= "InvoiceListModel.PaymentHeader";
//    public static final String c_DeductionHeader 			= "InvoiceListModel.DeductionHeader";
//    public static final String c_BalanceHeader 				= "InvoiceListModel.BalanceHeader";
//    
//    public static final int		c_TickedColumn				= 0;
//    public static final int		c_PatientNameColumn			= 1;
//    public static final int		c_PatientSSNColumn			= 2;
//    public static final int		c_InvoiceNumberColumn		= 3;
//    public static final int		c_InvoiceDateColumn			= 4;
//    public static final int		c_DueDateColumn				= 5;
//    public static final int		c_ReminderDateColumn		= 6;
//    public static final int		c_AmountColumn				= 7;
//    public static final int		c_PaymentColumn				= 8;
//    public static final int		c_DeductionColumn			= 9;
//    public static final int		c_BalanceColumn				= 10;
// 
//    static final public String c_TableHeaders [] = { 	c_TickedHeader,
//    													c_PatientNameHeader,
//    													c_PatientSSNHeader,
//    													c_InvoiceNumberHeader,
//       													c_InvoiceDateHeader,
//       													c_DueDateHeader,
//       													c_ReminderDateHeader,
//       													c_AmountHeader,
//    													c_PaymentHeader,
//    													c_DeductionHeader,
//    													c_BalanceHeader };
// 
////***************************************************************************
////* Constructor(s)                                                          *
////***************************************************************************
//
//public GenericInvoiceStubListModel ()
//    {
//    m_InvoiceStubs      = new Vector <InvoiceStub> ();
//    m_InvoiceStubLookup = new Hashtable <Integer,Integer> ();
//    }
//
////***************************************************************************
////* Class Primitives		                                                *
////***************************************************************************
////---------------------------------------------------------------------------
//
//private String getPatientName (InvoiceStub p_InvoiceStub)
//	{
//	String l_Name = "-";
//	
//	if (p_InvoiceStub != null)
//		{
//		l_Name = p_InvoiceStub.getPatientFullName();
//		}
//	return l_Name;
//	}
//
////---------------------------------------------------------------------------
//
//private String getPatientSSN (InvoiceStub p_InvoiceStup)
//	{
//	String  l_SSN		= "-";
//
//	if (p_InvoiceStup != null && p_InvoiceStup.getPatientSSN() != null)
//		{
//		l_SSN = Patient.formatSocialSecurityNumber(p_InvoiceStup.getPatientSSN());
//		}
//
//	return l_SSN;
//	}
//
////---------------------------------------------------------------------------
////***************************************************************************
////* Class Body		                                                        *
////***************************************************************************
////---------------------------------------------------------------------------
//
//public String getColumnName (int p_Column)
//    {
//    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
//    		{
//    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
//    		}
//    else return ("");
//    }
//
////---------------------------------------------------------------------------
//
//public int getColumnCount ()
//    {
//    return (c_TableHeaders.length);
//    }
//
////---------------------------------------------------------------------------
//
//public int getRowCount ()
//    {
//    return (m_InvoiceStubs.size());
//    }
//
////---------------------------------------------------------------------------
//
//public Object getValueAt (int p_Row, int p_Column)
//    {
//    InvoiceStub  l_InvoiceStub;
//    
//    l_InvoiceStub = new InvoiceStub ();
//    
//    if ((p_Row >= 0) && (p_Row < m_InvoiceStubs.size()))
//        {
//    	l_InvoiceStub = m_InvoiceStubs.elementAt (p_Row);
//    	if (l_InvoiceStub == null) l_InvoiceStub = new InvoiceStub ();
//        }
//    
//    switch (p_Column)
//        {
//        case  c_TickedColumn: 		return (l_InvoiceStub.getTicked() != null) ? l_InvoiceStub.getTicked() : false;
//        case  c_PatientNameColumn: 	return this.getPatientName (l_InvoiceStub);
//        case  c_PatientSSNColumn: 	return this.getPatientSSN (l_InvoiceStub);
//        case  c_InvoiceNumberColumn:return l_InvoiceStub.formatInvoiceNumber(Invoice.c_ShortFormat); 
//        case  c_InvoiceDateColumn: 	return (l_InvoiceStub.getInvoiceDate() != null) ? l_InvoiceStub.getInvoiceDate() : c_Epoch;
//        case  c_DueDateColumn: 		return (l_InvoiceStub.getDueDate() != null) ? l_InvoiceStub.getDueDate() : c_Epoch;
//        case  c_ReminderDateColumn: return (l_InvoiceStub.getReminderDate() != null) ? l_InvoiceStub.getReminderDate() : c_Epoch;
//        case  c_AmountColumn: 		return (l_InvoiceStub.getAmount() != null) ? l_InvoiceStub.getAmount() : 0;
//        case  c_PaymentColumn: 		return (l_InvoiceStub.getPayment() != null) ? l_InvoiceStub.getPayment() : 0;
//        case  c_DeductionColumn: 	return (l_InvoiceStub.getDeduction() != null) ? l_InvoiceStub.getDeduction() : 0;
//        case  c_BalanceColumn: 		return (l_InvoiceStub.getBalance() != null) ? l_InvoiceStub.getBalance() : 0;
//         
//        default: return "";
//        }
//    }
// 
////---------------------------------------------------------------------------
//
//public Class<?> getColumnClass (int p_Column) 
//    {
//    if (getValueAt(0, p_Column) != null)
//    		 return (Class<?>) getValueAt(0, p_Column).getClass();
//    else return null;
//    }
//
////---------------------------------------------------------------------------
//
//public boolean isEditable ()
//	{
//	return true;
//	}
//
////---------------------------------------------------------------------------
//
//public void setEditable (boolean p_Editable)
//	{
//	}
//
////---------------------------------------------------------------------------
//
//public boolean isCellEditable   (int p_Row, int p_Column)
//    {
//	if (p_Column == c_TickedColumn) 
//		 return true;
//	else return false;
//    }
//
////---------------------------------------------------------------------------
//
//public void setValueAt (Object p_Value, int p_Row, int p_Column)
//	{
//	InvoiceStub	l_InvoiceStub;
//	
//	if ((p_Row >= 0) && (p_Row < m_InvoiceStubs.size()))
//		{
//		l_InvoiceStub = m_InvoiceStubs.elementAt (p_Row);
//		if (l_InvoiceStub == null) return;
//	
//		switch (p_Column)
//			{
//			case  c_TickedColumn: l_InvoiceStub.setTicked((Boolean)p_Value);
//									m_InvoiceStubs.setElementAt(l_InvoiceStub, p_Row);
//									break;
//			}
//		fireTableCellUpdated (p_Row,p_Column);
//		}
//	}
//		
////---------------------------------------------------------------------------
//
//public InvoiceStub	getInvoiceStubAt (int p_Row)
//    {
//    InvoiceStub  l_InvoiceStub;
//     
//    if ((p_Row >= 0) && (p_Row < m_InvoiceStubs.size()))
//        {
//    	l_InvoiceStub = m_InvoiceStubs.elementAt (p_Row);
//        return l_InvoiceStub;
//        }
//    else return null;
//    }
//	
////---------------------------------------------------------------------------
//
//public void	setInvoiceStubAt (InvoiceStub p_InvoiceStub, int p_Row)
//    {     
//    if ((p_InvoiceStub != null) && (p_Row >= 0) && (p_Row < m_InvoiceStubs.size()))
//        {
//    	m_InvoiceStubs.setElementAt (p_InvoiceStub,p_Row);
//        m_InvoiceStubLookup.put (p_InvoiceStub.getId(),p_Row);
//        }
//    this.fireTableRowsUpdated(p_Row, p_Row);
//    }
//	
////---------------------------------------------------------------------------
//
//public void addInvoiceStub (InvoiceStub p_InvoiceStub)
//    {
//	int	l_Row;
//	
//	if (p_InvoiceStub != null)    
//        {    
//		m_InvoiceStubs.addElement (p_InvoiceStub);      
//        l_Row = m_InvoiceStubs.size() - 1;
//        m_InvoiceStubLookup.put (p_InvoiceStub.getId(), l_Row);
//        
//        fireTableRowsInserted (l_Row,l_Row);
//        }
//    }
//	
////---------------------------------------------------------------------------
//
//public void updateInvoiceStubs (Collection <InvoiceStub> p_InvoiceStubs)
//	{
//	Iterator <InvoiceStub>	l_InvoiceStubIterator;
//	InvoiceStub				l_InvoiceStub;	
//	Integer					l_Row;
//	
//	if ((p_InvoiceStubs == null) || (p_InvoiceStubs.isEmpty())) return;
//	
//	l_InvoiceStubIterator = p_InvoiceStubs.iterator();
//	while (l_InvoiceStubIterator.hasNext())
//		{
//		l_InvoiceStub = l_InvoiceStubIterator.next();
//		l_Row         = m_InvoiceStubLookup.get(l_InvoiceStub.getId());
//		if (l_Row != null) this.setInvoiceStubAt (l_InvoiceStub, l_Row);
//		}
//	}
//
////---------------------------------------------------------------------------
//
//public void removeInvoiceStub (InvoiceStub p_InvoiceStub)
//	{
//	int	l_Index;
//	
//	if (p_InvoiceStub != null)
//		{
//		l_Index = m_InvoiceStubs.indexOf (p_InvoiceStub);
//		if (l_Index >= 0) 
//			{
//			this.removeInvoiceStubAt (l_Index);
//			}
//		}
//	}
//
////---------------------------------------------------------------------------
//
//public void removeInvoiceStubs (Collection <Integer> p_InvoiceIds)
//	{
//	Iterator <Integer>	l_Iterator;
//	Integer				l_Id;	
//	Integer				l_Row;
//	
//	if ((p_InvoiceIds == null) || (p_InvoiceIds.isEmpty())) return;
//	
//	l_Iterator = p_InvoiceIds.iterator();
//	while (l_Iterator.hasNext())
//		{
//		l_Id  = l_Iterator.next();
//		l_Row = m_InvoiceStubLookup.get(l_Id);
//		
//		if (l_Row != null) this.removeInvoiceStubAt(l_Row);
//		}
//	}
//
////---------------------------------------------------------------------------
//
//public void removeAllInvoiceStubs ()
//	{
//	int	l_LastRow;
//	
//	l_LastRow = m_InvoiceStubs.size() -1;
//
//	m_InvoiceStubs.removeAllElements ();
//	m_InvoiceStubLookup.clear();
//	
//	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
//	}
//
////---------------------------------------------------------------------------
//
//public void removeInvoiceStubAt (int p_Row)
//    {
//	InvoiceStub l_InvoiceStub;
//	
//	if ((p_Row >= 0) && (p_Row < m_InvoiceStubs.size()))
//        {
//		l_InvoiceStub = m_InvoiceStubs.elementAt (p_Row);  	
//    	m_InvoiceStubs.removeElementAt (p_Row);
//    	m_InvoiceStubLookup.remove(l_InvoiceStub.getId());
//    	
//    	fireTableRowsDeleted (p_Row,p_Row);
//        }
//    }
//
////---------------------------------------------------------------------------
//
//public int findInvoiceStub (Integer p_InvoiceId)
//    {
//	Integer		l_Row;    
// 	
// 	if (p_InvoiceId == null) return -1;
// 	
// 	l_Row = m_InvoiceStubLookup.get (p_InvoiceId);
// 	
// 	return (l_Row != null)?l_Row:-1;
//    }
//
////---------------------------------------------------------------------------
//
//public boolean containsInvoiceStub (InvoiceStub p_InvoiceStub)
//	{
//	return m_InvoiceStubs.contains (p_InvoiceStub);
//	}
//	
////---------------------------------------------------------------------------
//
//public void setInvoiceStubs (Collection <InvoiceStub> p_InvoiceStubs)
//    {
// 	Iterator <InvoiceStub>	l_InvoiceStubIterator;
// 	InvoiceStub				l_InvoiceStub;
//	int						l_Row = 0;
//	
//	if (p_InvoiceStubs == null) return;
//        
//    removeAllInvoiceStubs ();
// 
//    l_InvoiceStubIterator = p_InvoiceStubs.iterator();
//    while (l_InvoiceStubIterator.hasNext())
//    	{
//    	l_InvoiceStub = l_InvoiceStubIterator.next();
//    	m_InvoiceStubs.add (l_InvoiceStub);
//    	m_InvoiceStubLookup.put(l_InvoiceStub.getId(), l_Row++);
//    	}
//      
//    fireTableRowsInserted (0,p_InvoiceStubs.size());
//    }
//
////---------------------------------------------------------------------------
//
//public void addInvoiceStubs (Collection <InvoiceStub> p_InvoiceStubs)
//	{
//	Iterator <InvoiceStub>	l_InvoiceStubIterator;
// 	InvoiceStub				l_InvoiceStub;
//	int						l_PreviousLastRow;
// 	int						l_Row = 0;
//
//	if (p_InvoiceStubs == null) return;
//  	
//	l_Row			  = m_InvoiceStubs.size();
//	l_PreviousLastRow = l_Row - 1;
//	
//    l_InvoiceStubIterator = p_InvoiceStubs.iterator();
//    while (l_InvoiceStubIterator.hasNext())
//    	{
//    	l_InvoiceStub = l_InvoiceStubIterator.next();
//    	m_InvoiceStubs.add (l_InvoiceStub);
//    	m_InvoiceStubLookup.put(l_InvoiceStub.getId(), l_Row++);
//    	}
//     
//    fireTableRowsInserted (l_PreviousLastRow,p_InvoiceStubs.size());	
//	}
//
////---------------------------------------------------------------------------
//
//public Collection <InvoiceStub> getInvoiceStubs ()
//    {
//	Vector <InvoiceStub> l_InvoiceStubs;
//	
//	l_InvoiceStubs = new Vector <InvoiceStub> (m_InvoiceStubs);
//	
//	return l_InvoiceStubs;
//    }    
//        
////---------------------------------------------------------------------------
//
//public Collection <InvoiceStub> getTickedInvoiceStubs ()
//    {
//	Collection <InvoiceStub> 	l_TickedInvoiceStubs;
//	Iterator <InvoiceStub>		l_InvoiceStubIterator;
//	InvoiceStub					l_InvoiceStub;
//	
//	l_TickedInvoiceStubs = new ArrayList <InvoiceStub> (); 
//	
//	l_InvoiceStubIterator = m_InvoiceStubs.iterator();
//	while (l_InvoiceStubIterator.hasNext())
//		{
//		l_InvoiceStub = l_InvoiceStubIterator.next();
//		if (l_InvoiceStub.getTicked()) l_TickedInvoiceStubs.add(l_InvoiceStub);
//		}
//	
//	return l_TickedInvoiceStubs;
//    }    
//
////---------------------------------------------------------------------------
//
//public void tickInvoiceStubs (Collection <InvoiceStub> p_ToBeTicked)
//	{
//	Iterator <InvoiceStub>		l_InvoiceStubIterator;
//	InvoiceStub					l_InvoiceStub;
//	
//	l_InvoiceStubIterator = m_InvoiceStubs.iterator();
//	while (l_InvoiceStubIterator.hasNext())
//		{
//		l_InvoiceStub = l_InvoiceStubIterator.next();
//		if (p_ToBeTicked.contains(l_InvoiceStub)) l_InvoiceStub.setTicked(true);
//		}
//	}
//
////---------------------------------------------------------------------------
////***************************************************************************
////* End of Class															*
////***************************************************************************
//}
