/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * InvoiceListModel.java
 *
 * Created on March 31, 2006
 */

package lu.tudor.santec.gecamed.billing.gui.invoice.stub;

/**
 *
 * @author  santec
 */

import java.util.Collection;
import java.util.Date;

import javax.swing.table.TableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public interface GenericInvoiceStubListInterface extends TableModel
    {
	public static final Date c_Epoch = new Date (0);

	public InvoiceStub 				getInvoiceStubAt 		(int p_Row);
    public void						setInvoiceStubAt 		(InvoiceStub p_InvoiceStub, int p_Row);
    public void 					addInvoiceStub 			(InvoiceStub p_InvoiceStub);
    public void 					removeAllInvoiceStubs 	();
    public void 					removeInvoiceStubAt 	(int p_Row);
    public void 					removeInvoiceStub   	(InvoiceStub p_InvoiceStub);
    public boolean 					containsInvoiceStub 	(InvoiceStub p_InvoiceStub);
    public int 						findInvoiceStub 		(Integer p_InvoiceId);
    public void 					setInvoiceStubs 		(Collection <InvoiceStub> p_InvoiceStubs);
    public Collection <InvoiceStub> getInvoiceStubs 		();
    
    public boolean 					isEditable 				(); 
    public void 					setEditable 			(boolean p_Editable);					
    
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
