/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.invoice;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.text.MaskFormatter;


/**
 * The StatementNumberFormatter swing component eases the input of Third Party Payment 
 * Statement number. Those number are in the format TXXXXXXX. The 7 Xs represent the actual 
 * statement ID.
  * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class StatementNumberFormatter extends MaskFormatter                                                              
    {
    private static final long serialVersionUID = 1L;
     
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    
    public static final String c_EmptyField = "T0000000";
  
    private static final String c_Format = "T#######";
   
    private static Pattern 
    
    c_StatementIDPattern = Pattern.compile ("^T(\\d{7})$",Pattern.CASE_INSENSITIVE);
    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public StatementNumberFormatter () 
    {
	try {
		this.setMask(c_Format);
		} 
    catch (ParseException p_Exception) 
        {
    		//Can be safely ignored here.
        }
    
    this.setAllowsInvalid(false);
    this.setValidCharacters("0123456789");
    this.setPlaceholderCharacter('0');
    this.setOverwriteMode(true);
    this.setValueContainsLiteralCharacters(true);
    this.setCommitsOnValidEdit(false);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public Object stringToValue (String p_InvoiceNumber)
	{
	Object	l_Value;
	
//	this.setEditValid(true);
	l_Value = p_InvoiceNumber;
	
	return l_Value;
	}

//---------------------------------------------------------------------------

public String valueToString (Object p_Value)
	{
	String	l_String;
	
//	this.setEditValid(true);
	l_String = (String) p_Value;
	
	return l_String;
	}

//---------------------------------------------------------------------------

public static int getStatementID (String p_StatementNumber)
	{
	Matcher l_Matcher;
	Integer	l_StatementID = 0;
	
	l_Matcher = c_StatementIDPattern.matcher(p_StatementNumber);
	if (l_Matcher.matches())
		{
		try {
			l_StatementID = Integer.parseInt(l_Matcher.group(1));
		    }
		catch (NumberFormatException p_Exception)
		    {
			l_StatementID = 0;
		    }
		}
	
	return l_StatementID;
	}


//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

