/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.invoice;

import java.text.ParseException;
import java.util.regex.Pattern;

import javax.swing.text.MaskFormatter;


/**
 * The UCMCodeField swing component eases the input of UCM (Union des Caisses de Maladie) 
 * codes. UCM codes come in the format XXXXXX-YY. The 6 Xs represent the actual UCM code
 * whereas the 2 Ys are merely a checksum calculated from the 6 digits. Checksum
 * calculation is a simple module 97 operation. The UCMCodeField coerces the code
 * format and features an autocomplete function, triggered when hitting the '-' key.
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class InvoiceNumberFormatter extends MaskFormatter                                                              
    {
    private static final long serialVersionUID = 1L;
     
    private String	m_EmptyField;
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

    public static final boolean c_ShortFormat = true;
    public static final boolean c_LongFormat  = false;
    
    public static final String c_EmptyFieldShort = "0000000";
    
    public static final String c_EmptyFieldLong = "00/0000000-0000000";

    private static final String c_ShortFormatMask = "#######";
    
    private static final String c_LongFormatMask = "##/#######-#######";
   
    private static Pattern 
    
    c_LongPattern = Pattern.compile ("^(\\d{2})\\/(\\d{7})-(\\d{7})$",Pattern.CASE_INSENSITIVE);
    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public InvoiceNumberFormatter(boolean p_Short) 
    {
	try {
		if (p_Short) 
			{
			m_EmptyField = c_EmptyFieldShort;
			this.setMask(c_ShortFormatMask);
			}
		else 
			{
			m_EmptyField = c_EmptyFieldLong;
			this.setMask(c_LongFormatMask);
			}
		} 
    catch (ParseException p_Exception) 
        {
    		//Can be safely ignored here.
        }
    
    this.setAllowsInvalid(false);
    this.setValidCharacters("0123456789");
    this.setPlaceholderCharacter('0');
    this.setOverwriteMode(true);
    this.setValueContainsLiteralCharacters(true);
    this.setCommitsOnValidEdit(false);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public Object stringToValue (String p_InvoiceNumber)
	{
	Object	l_Value;
	
//	this.setEditValid(true);
	l_Value = p_InvoiceNumber;
	
	return l_Value;
	}

//---------------------------------------------------------------------------

public String valueToString (Object p_Value)
	{
	String	l_String = null;
	int		l_Padding;
	
	if (p_Value != null)
		{
		l_String = (String) p_Value;
		
		l_Padding = m_EmptyField.length() - l_String.length();
		if (l_Padding > 0)
			{
			l_String = m_EmptyField.substring(0, l_Padding) + l_String;
			}
		}

	return l_String;
	}

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

