package lu.tudor.santec.gecamed.billing.gui.invoice;

import java.awt.BorderLayout;
import java.text.DateFormat;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import com.toedter.calendar.JDateChooser;

import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.i18n.Translatrix;


/**
 * @author hermenj
 *
 * @version
 * <br>$Log: DueDateDialog.java,v $
 */
public class DueDateDialog extends GECAMedBaseDialog {

	private DateFormat df = GECAMedGuiUtils.getDateFormat(false);
	private JDateChooser dateChooser;
	private JLabel messageLabel;

	public DueDateDialog() {
		super(Translatrix.getTranslationString("DueDateDialog.title"));
		
		JPanel mainPanel = new JPanel(new BorderLayout(10,10));
		mainPanel.setOpaque(false);
		mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		
		messageLabel = new JLabel();
		mainPanel.add(messageLabel, BorderLayout.CENTER);
		
		dateChooser = GECAMedGuiUtils.getDateChooser(false);
		mainPanel.add(dateChooser, BorderLayout.SOUTH);
		
		addMainPanel(mainPanel);
		
		setSize(450, 200);
	}

	private static final long serialVersionUID = 1L;

	public int showDueDateDialog(Date invoiceDate, Date proposedDueDate) {
		messageLabel.setText(Translatrix.getTranslationString("DueDateDialog.message", new String[] {df.format(invoiceDate)}));
		
		dateChooser.setDate(proposedDueDate);
		
		return showCenteredDialog ();
	}
	
	public Date getDueDate() {
		return dateChooser.getDate();
	}
	
	
	public static void main(String[] args) {

	}

}
