/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.hospitalisation;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractListModel;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationClass;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@SuppressWarnings("rawtypes")
public class HospitalisationClassListModel extends AbstractListModel 
	{
	private static final long serialVersionUID = 1L;
	
	private Vector <HospitalisationClass> 	m_HospitalisationClasses;
	private Hashtable <String, Integer> 	m_HospitalisationClassLookup;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
	
public 	HospitalisationClassListModel ()
	{
	m_HospitalisationClasses 	 = new Vector <HospitalisationClass> ();
	m_HospitalisationClassLookup = new Hashtable <String, Integer> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	
public HospitalisationClass getElementAt (int p_Index) 
	{
	if ((p_Index >= 0) && (p_Index < m_HospitalisationClasses.size()))
		{
		return m_HospitalisationClasses.elementAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getSize() 
	{
	return m_HospitalisationClasses.size();
	}

//---------------------------------------------------------------------------

public boolean contains (HospitalisationClass p_Candidate)
	{
	if (p_Candidate != null)
		 return m_HospitalisationClassLookup.containsKey(p_Candidate.getAcronym());
	else return false;
	}

//---------------------------------------------------------------------------

public int getElementPosition (HospitalisationClass p_Candidate)
	{
	if (this.contains (p_Candidate))
		{
		return m_HospitalisationClassLookup.get(p_Candidate.getAcronym());
		}
	else return -1;
	}

//---------------------------------------------------------------------------

public void setHospitalisationClasses (Collection <HospitalisationClass> p_Insurances)	
	{
	Iterator <HospitalisationClass> 	l_ClassIterator;
	HospitalisationClass			 	l_Class;
	int					 				l_Position = 0;
	
	m_HospitalisationClasses.removeAllElements();
	m_HospitalisationClassLookup.clear();
	
	if (p_Insurances != null)
		{
		l_ClassIterator = p_Insurances.iterator();
		while (l_ClassIterator.hasNext())
			{
			l_Class = l_ClassIterator.next();
			m_HospitalisationClasses.add(l_Class);
			m_HospitalisationClassLookup.put(l_Class.getAcronym(), l_Position++);
			}
		}
	}

//---------------------------------------------------------------------------

public Collection <HospitalisationClass> getHospitalisationClasses ()
	{
	return m_HospitalisationClasses;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
