/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.event.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class SearchModeEventDispatcher 
{
	private Collection <SearchModeListener> m_SearchModeListeners;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public SearchModeEventDispatcher ()
	{
	m_SearchModeListeners = new ArrayList <SearchModeListener> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------


public void addSearchModeListener (SearchModeListener p_Listener)
	{
	if ((m_SearchModeListeners == null) || (p_Listener == null)) return;
	
	m_SearchModeListeners.add(p_Listener);
	}

//---------------------------------------------------------------------------

public void removeSearchModeListener (SearchModeListener p_Listener)
	{
	if ((m_SearchModeListeners == null) || (p_Listener == null)) return;

	m_SearchModeListeners.remove(p_Listener);
	}

//---------------------------------------------------------------------------

public void notifySearchModeListeners (SearchModeEvent p_Event)
	{
	Iterator <SearchModeListener>	l_ListenerIterator;
	SearchModeListener				l_Listener;
	
	if (m_SearchModeListeners == null) return;
	
	l_ListenerIterator = m_SearchModeListeners.iterator();
	while (l_ListenerIterator.hasNext())
		{
		l_Listener = l_ListenerIterator.next();
		l_Listener.searchModeChanged (p_Event);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}
