/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.event.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

/**
 * The KeyValueEventDispatcher class basically encapsulates functionality
 * required to manage KeyValueChangeChangeEvents Listeners. It offers methods to 
 * add and remove KeyValueListeners as well as a method to call every registered
 * listener's keyValueChanged method.
 * @author nico.mack@tudor.lu
 */

public class KeyValueEventDispatcher 
{
	private Collection <KeyValueListener> m_KeyValueListeners;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new instance of KeyValueEventDispatcher class.
 */
//---------------------------------------------------------------------------

public KeyValueEventDispatcher ()
	{
	m_KeyValueListeners = new ArrayList <KeyValueListener> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Adds the specified KeyValueListener to the list of listeners to be
 * notified.
 * @param p_Listener specifies the KeyValueListener to be added
 */
//---------------------------------------------------------------------------

public void addKeyValueListenerListener (KeyValueListener p_Listener)
	{
	if ((m_KeyValueListeners == null) || (p_Listener == null)) return;
	
	m_KeyValueListeners.add(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * Removes the specified KeyValueListener from the list of listeners to be
 * notified.
 * @param p_Listener specifies the KeyValueListener to be removed
 */
//---------------------------------------------------------------------------

public void removeKeyValueListenerListener (KeyValueListener p_Listener)
	{
	if ((m_KeyValueListeners == null) || (p_Listener == null)) return;

	m_KeyValueListeners.remove(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * the notifyKeyValueListeners will notify all the registered Listener's
 * about the key value change represented by the specified key value event.
 * Notification is done by calling every listener's <code>keyValueChanged</code>
 * method.
 * @param p_Event specifies the key value change event to be passed to every
 * listener's <code>keyValueChanged</code> method.
 */
//---------------------------------------------------------------------------

public void notifyKeyValueListeners (KeyValueChangeEvent p_Event)
	{
	Iterator <KeyValueListener>	l_ListenerIterator;
	KeyValueListener			l_Listener;
	
	if (m_KeyValueListeners == null) return;
	
	l_ListenerIterator = m_KeyValueListeners.iterator();
	while (l_ListenerIterator.hasNext())
		{
		l_Listener = l_ListenerIterator.next();
		l_Listener.keyValueChanged(p_Event);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}
