/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.event.keyvalue;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;

//***************************************************************************
//* Class Definition		                                            	*
//***************************************************************************

public class KeyValueChangeEvent 
	{
	private	Object			m_Source;
	private int				m_Type;
	private KeyValue		m_KeyValue;

//***************************************************************************
//* Constants	                                                            *
//***************************************************************************

	public static final int c_None			   			= 0;
	public static final int c_KeyValueCreated 			= 1;
	public static final int c_KeyValueUpdated 			= 2;
	public static final int c_KeyValueDeleted 			= 3;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public 	KeyValueChangeEvent ()
	{
	m_Source   		= null;
	m_Type			= c_None;
	m_KeyValue		= null;
	}
		
//---------------------------------------------------------------------------

public 	KeyValueChangeEvent (Object p_Source, KeyValue p_KeyValue, int p_Type)
	{
	m_Source   	= p_Source;
	m_KeyValue	= p_KeyValue;
	m_Type		= p_Type;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Object getSource ()
	{
	return m_Source;
	}

//---------------------------------------------------------------------------

public void setSource (Object p_Source)
	{
	m_Source = p_Source;
	}

//---------------------------------------------------------------------------

public int getType ()
	{
	return m_Type;
	}

//---------------------------------------------------------------------------

public void setType (int p_Type)
	{
	if ((p_Type >= c_None) && (p_Type <= c_KeyValueDeleted))
		{
		m_Type = p_Type;
		}
	else m_Type = c_None;
	}

//---------------------------------------------------------------------------

public KeyValue getKeyValue ()
	{
	return m_KeyValue;
	}

//---------------------------------------------------------------------------

public void setKeyValue (KeyValue p_KeyValue)
	{
	m_KeyValue = p_KeyValue;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
//---------------------------------------------------------------------------
}
