/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.config;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.ejb.session.beans.SettlementBean;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.SettlementInterface;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.billing.utils.BillingAdminSettings;
import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.core.utils.SettingPluginNames;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;
import lu.tudor.santec.widgets.NumericJTextField;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
*
* @author nmac / jhermen
*/

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class BillingAdminSettingsPlugin extends SettingsPlugin implements ItemListener
	{
	private static final long serialVersionUID = 1L;
	
	private JPanel					m_BillingSettingsPanel;
	private JPanel					m_ReminderSettingsPanel;
	
	private JLabel					m_SplitBillingLabel;
	private JCheckBox				m_SplitBilling;
	
	private JLabel					m_ShortInvoiceNumbersLabel;
	private JCheckBox				m_ShortInvoiceNumbers;

	private JLabel 					m_UseLeadingZerosLabel;
	private JCheckBox 				m_UseLeadingZeros;

	private JLabel					m_HospitalisationLabel;
	private JCheckBox				m_Hospitalisation;
	
	private JLabel					m_HospitalCumulationModeLabel;
	private JRadioButton			m_HospitalCumulationModeNormalBox;
	private JRadioButton			m_HospitalCumulationModeFullFActBox;
	private JRadioButton			m_HospitalCumulationModeFullBox;
	
	private JLabel					m_SessionModeLabel;
	private JCheckBox				m_SessionModeBox;
	
	private JLabel					m_3PPValueLabel;
	private NumericJTextField		m_3PPValueField;
	
	private JLabel					m_ThirdPartyStatementsLabel;	
	private JCheckBox				m_ThirdPartyStatements;
	
	private JLabel					m_MaxInvoicesLabel;
	private JFormattedTextField		m_MaxInvoices;
	private JLabel					m_MaxInvoicesUnit;

	private JLabel					m_AddressStyleLabel;
	private JComboBox				m_AddressStyle;

	private JLabel					m_DefaultAccountLabel;
	private JComboBox				m_DefaultAccount;

	private JLabel					m_DuePeriodLabel;
	private JFormattedTextField		m_DuePeriod;
	private JLabel					m_DuePeriodUnit;
	
	private JLabel					m_OnlyExpiredInvoicesLabel;	
	private JCheckBox				m_OnlyExpiredInvoices;

	private JLabel					m_PrintWithEachHeading;
	
	private JLabel					m_ReminderCopiesLabel;
	private JSpinner				m_ReminderCopies;
	private JLabel					m_ReminderCopiesUnit;
	
	private JLabel					m_ReminderInvoicesLabel;
	private JSpinner				m_ReminderInvoices;
	private JLabel					m_ReminderInvoicesUnit;
	private JLabel					m_JoinReminderOfPatientLabel;
	private JCheckBox				m_JoinReminderOfPatient;
	
	private JLabel					m_PaymentOrderCopiesLabel;
	private JSpinner				m_PaymentOrderCopies;
	private JLabel					m_PaymentOrderCopiesUnit;
	
	private JLabel					m_PaymentOrderInvoicesLabel;
	private JSpinner				m_PaymentOrderInvoices;
	private JLabel					m_PaymentOrderInvoicesUnit;
	
	private JLabel 					m_JoinPaymentOrdersOfPatientLabel;
	private JCheckBox 				m_JoinPaymentOrdersOfPatient;

	private JPanel m_InvoiceSettingsPanel;

	private JPanel m_RuleengineSettingsPanel;

	private JLabel m_ShowInfoColumnLabel;

	private JCheckBox m_ShowInfoColumn;

	private JLabel m_ShowMedPrescColumnLabel;

	private JCheckBox m_ShowMedPrescColumn;

	private JLabel m_ShowUsernameColumnLabel;

	private JCheckBox m_ShowUsernameColumn;

	private JLabel m_ShowAdjustColumnLabel;

	private JCheckBox m_ShowAdjustColumnColumn;
	
	private JCheckBox m_PrintCNSCodeBox;
	
	private JLabel m_PrintCNSCodeLabel;

	private JCheckBox m_PrintZeroActsBox;
	
	private JLabel m_PrintZeroActsLabel;

	private JPanel m_ActCheckSettingsPanel;

	private JLabel m_ActFutureLabel;

	private JCheckBox m_ActFuture;

	private JLabel m_ActBeforeBirthLabel;

	private JCheckBox m_ActBeforeBirth;

	private JLabel m_ActBirthdateCheckLabel;

	private JCheckBox m_ActBirthdateCheck;

	private IntegerField m_ActBirthdateMax;
	
//	private JLabel m_ShowMedTransPanelLabel;
//
//	private JCheckBox m_ShowMedTransPanel;
	
	private static Logger m_Logger = Logger.getLogger (BillingAdminSettingsPlugin.class.getName());
	
	private static Hashtable <Integer,Account> m_Accounts;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	public static final boolean c_SplitBillingStationary 			= true;
	public static final boolean c_ShortInvoiceNumbersStationary 	= false;
	public static final boolean c_UseLeadingZerosStationary 		= true;
	public static final boolean c_HospitalisationStationary     	= false;
//	public static final boolean c_CumulateAllIfHospStationary		= BillingAdminSettings.c_CumulateAllIfHospitalizedDefault;
	public static final int		c_HospitalizedCumulationStationary	= BillingAdminSettings.c_HospitalizedCumulationModeDefault;
	public static final boolean	c_UseSessionModeStationary			= BillingAdminSettings.c_UseSessionModeDefault;
	public static final int		c_TiersPayantMinValueStationary		= BillingAdminSettings.c_TiersPayantMinValueDefault;
	
	public static final boolean c_ThirdPartyStatementsStationary 	= true;
	public static final int		c_AddressStyleStationary 			= BillingAdminSettings.c_CapitalizeWordStyle;
	public static final int     c_DuePeriodStationary 				= 30;
	public static final int     c_MaxInvoicesStationary 			= 3000;
	public static final boolean c_OnlyExpiredInvoicesStationary 	= true;
	public static final int		c_ReminderCopiesStationary			= 1;
	public static final int		c_ReminderInvoicesStationary		= 1;
	public static final boolean	c_JoinRemindersStationary			= false;
	public static final int		c_PaymentOrderCopiesStationary		= 6;
	public static final int		c_PaymentOrderInvoicesStationary	= 1;
	public static final boolean	c_JoinPaymentOrdersStationary		= false;
	public static final int		c_DefaultAccountIdStationary		= 1;
	
	public static final boolean c_ShowMedPrescColumn 				= true;
	public static final boolean c_ShowInfoColumn 					= true;
	public static final boolean c_ShowUserColumn 					= true;
	public static final boolean c_ShowAdjustColumn 					= true;
	
	public static final boolean c_ShowMedTransPanel 				= false;
	
	private final static String c_BillingColumns	= 	"3dlu,fill:max(100dlu;pref)," +
														"3dlu,fill:max(50dlu;pref)," +
														"3dlu,fill:max(20dlu;pref),3dlu";
	private final static String c_BillingRows		=   "3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref,3dlu";
	
	private final static String c_InvoiceColumns	= 	"3dlu,fill:max(100dlu;pref)," +
														"3dlu,fill:max(5dlu;pref)," +
														"3dlu,fill:max(2dlu;pref),3dlu";
	private final static String c_InvoiceRows		=   "3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref,3dlu";
	
	private final static String c_RuleengineColumns	= 	"3dlu,fill:max(100dlu;pref)," +
														"3dlu,fill:max(50dlu;pref)," +
														"3dlu";
	private final static String c_RuleengineRows	=	"3dlu,fill:pref," +	// hospitalization cumulation: normal 
														"3dlu,fill:pref," +	// hospitalization cumulation: full with F-act
														"3dlu,fill:pref," +	// hospitalization cumulation: full
														"3dlu,fill:pref," +	// session mode
														"3dlu,fill:pref," +	// 3PP min value
														"3dlu";
	

	private final static String c_ReminderColumns	= 	"3dlu,fill:max(100dlu;pref)," +
														"3dlu,fill:max(50dlu;pref)," +
														"3dlu,fill:max(20dlu;pref),3dlu";
	private final static String c_ReminderRows		=   "3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"10dlu,fill:pref," +
														"5dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref," +
														"10dlu,fill:pref," +
														"3dlu,fill:pref," +
														"3dlu,fill:pref,3dlu";
	
	private final static String c_AccountTemplate =
		
		"<html>" + AccountComboBoxRenderer.c_BankPlaceHolder + "<br>" +
        "<span style=\"font-size: 7px\">" + AccountComboBoxRenderer.c_IBANPlaceHolder + "</span></html>";

//***************************************************************************
//* Constructors                                       						*
//***************************************************************************
	
//---------------------------------------------------------------------------
	
public BillingAdminSettingsPlugin (String p_Name) 
	{
	super(p_Name);
	this.init();
	}

//---------------------------------------------------------------------------

public BillingAdminSettingsPlugin () 
	{
	super(SettingPluginNames.BILLING_SETTINGS_PLUGIN_NAME);
	this.init();
	}
	
//---------------------------------------------------------------------------

private void init ()
	{
	m_Accounts = new Hashtable <Integer,Account> ();
	this.fetchAccounts();
	
	this.setStationaryValues();
	buildPanel();	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

private SettlementInterface getSettlementInterface ()
	{
	SettlementInterface l_SettlementInterface = null;

	try {
		l_SettlementInterface = (SettlementInterface) ManagerFactory.getRemote(SettlementBean.class);
//		InitialContext l_Context = new InitialContext();
//		l_SettlementInterface = (SettlementInterface) l_Context.lookup("SettlementBean/remote");
//		l_Context.close();
		} 
	catch (Exception p_Exception) 
		{
		m_Logger.log(Level.ERROR, "Failed to get Settlement Interface!", p_Exception);
		}

	return l_SettlementInterface;
	}

//---------------------------------------------------------------------------

private void fetchAccounts ()
	{
	SettlementInterface  	l_SettlementInterface;
	Collection <Settlement>	l_Settlements;
	Iterator <Settlement>	l_SettlementIterator;
	Settlement				l_Settlement;
	Account					l_Account;
	
	l_SettlementInterface = this.getSettlementInterface();
	if (l_SettlementInterface != null)
		{
		try	{
			l_Settlements = l_SettlementInterface.getTransferSettlements();
			if (l_Settlements != null)
				{
				l_SettlementIterator = l_Settlements.iterator();
				while (l_SettlementIterator.hasNext())
					{
					l_Settlement = l_SettlementIterator.next();
					l_Account    = l_Settlement.getTransferAccount();
					if (l_Account != null) m_Accounts.put(l_Account.getId(), l_Account);
					}	
				}
			}
		catch (Exception p_Exception)
			{
			m_Logger.log(Level.WARN, "Failed to fetch Accounts!", p_Exception);
			}
		}
	}

//---------------------------------------------------------------------------

private void populateDefaultAccountChooser ()
	{
	Enumeration <Account> l_Accounts;
	
	l_Accounts = m_Accounts.elements();
	while (l_Accounts.hasMoreElements()) m_DefaultAccount.addItem(l_Accounts.nextElement());
	}

//---------------------------------------------------------------------------

private void populateAddressStyleChooser ()
	{
	m_AddressStyle.addItem (Integer.valueOf (BillingAdminSettings.c_OriginalStyle));
	m_AddressStyle.addItem (Integer.valueOf (BillingAdminSettings.c_UpperCaseStyle));
	m_AddressStyle.addItem (Integer.valueOf (BillingAdminSettings.c_CapitalizeWordStyle));
	}

//---------------------------------------------------------------------------

//private Account getAccountByID (Integer p_AccountID)
//	{
//	Account l_Account;
//	
//	if (m_Accounts != null)
//		 l_Account = m_Accounts.get(p_AccountID);
//	else l_Account = null;
//	
//	if (l_Account == null) l_Account = new Account ();
//	
//	return l_Account;
//	}

//---------------------------------------------------------------------------

private void buildPanel() 
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
	NumberFormat	l_NumberFormat;
	SpinnerModel	l_SpinnerModel;
	
	//======================================================================
	//= Build General Billing Settings Panel
	//======================================================================
	
	l_Layout = new FormLayout(c_BillingColumns, c_BillingRows);
	l_Constraints  = new CellConstraints();
	
	m_BillingSettingsPanel = createSubPanel("");
	m_BillingSettingsPanel.setLayout(l_Layout);
	
	m_SplitBillingLabel = new JLabel ();
	m_SplitBilling 		= new JCheckBox ();
	
	m_ShortInvoiceNumbersLabel = new JLabel ();
	m_ShortInvoiceNumbers 	   = new JCheckBox ();
	
	m_UseLeadingZerosLabel 		= new JLabel ();
	m_UseLeadingZeros 			= new JCheckBox ();
	
	m_ThirdPartyStatementsLabel			= new JLabel ();
	m_ThirdPartyStatements				= new JCheckBox ();
	
	l_NumberFormat = NumberFormat.getIntegerInstance();
	
	m_MaxInvoicesLabel 	= new JLabel ();
	m_MaxInvoices 		= new JFormattedTextField (l_NumberFormat);
	m_MaxInvoicesUnit 	= new JLabel ();
	
	m_AddressStyleLabel	  = new JLabel ();
	m_AddressStyle		  = new JComboBox ();
	m_AddressStyle.setRenderer (new AddressStyleComboBoxRenderer ());
	this.populateAddressStyleChooser();
	
	m_DefaultAccountLabel = new JLabel ();
	m_DefaultAccount      = new JComboBox ();
	m_DefaultAccount.setRenderer (new AccountComboBoxRenderer (c_AccountTemplate));	
	this.populateDefaultAccountChooser ();
	
	int row = 0;
	m_BillingSettingsPanel.add (m_SplitBillingLabel,  				l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_SplitBilling,   					l_Constraints.xywh(4, row,    3, 1));
	m_BillingSettingsPanel.add (m_ShortInvoiceNumbersLabel,  		l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_ShortInvoiceNumbers,   			l_Constraints.xywh(4, row,    3, 1));
	m_BillingSettingsPanel.add (m_UseLeadingZerosLabel,  			l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_UseLeadingZeros,   				l_Constraints.xywh(4, row,    3, 1));
	m_BillingSettingsPanel.add (m_ThirdPartyStatementsLabel,  		l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_ThirdPartyStatements,   			l_Constraints.xywh(4, row,    3, 1));
	m_BillingSettingsPanel.add (m_MaxInvoicesLabel,  				l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_MaxInvoices,   					l_Constraints.xywh(4, row,    1, 1));
	m_BillingSettingsPanel.add (m_MaxInvoicesUnit,   				l_Constraints.xywh(6, row,    1, 1));
	m_BillingSettingsPanel.add (m_AddressStyleLabel,  				l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_AddressStyle,   					l_Constraints.xywh(4, row,    3, 1));
	m_BillingSettingsPanel.add (m_DefaultAccountLabel,  			l_Constraints.xywh(2, row+=2, 1, 1));
	m_BillingSettingsPanel.add (m_DefaultAccount,   				l_Constraints.xywh(4, row,    3, 1));
	
	//======================================================================
	//= Build Invoice Entry Display Panel
	//======================================================================

	l_Layout					= new FormLayout(c_InvoiceColumns, c_InvoiceRows);
	l_Constraints				= new CellConstraints();
		
	m_InvoiceSettingsPanel = createSubPanel("");
	m_InvoiceSettingsPanel.setLayout(l_Layout);
	
	m_HospitalisationLabel		= new JLabel ();
	m_Hospitalisation			= new JCheckBox ();
	m_Hospitalisation.addItemListener(this);
		
	m_ShowInfoColumnLabel		= new JLabel ();
	m_ShowInfoColumn			= new JCheckBox ();
	m_ShowInfoColumn.addItemListener(this);
	
	m_ShowMedPrescColumnLabel	= new JLabel ();
	m_ShowMedPrescColumn		= new JCheckBox ();
	m_ShowMedPrescColumn.addItemListener(this);
	
	m_ShowUsernameColumnLabel	= new JLabel ();
	m_ShowUsernameColumn		= new JCheckBox ();
	m_ShowUsernameColumn.addItemListener(this);
	
	m_ShowAdjustColumnLabel		= new JLabel ();
	m_ShowAdjustColumnColumn	= new JCheckBox ();
	m_ShowAdjustColumnColumn.addItemListener(this);
	
	m_PrintCNSCodeLabel			= new JLabel ();
	m_PrintCNSCodeBox			= new JCheckBox ();
	m_PrintCNSCodeBox.addItemListener(this);
	
	m_PrintZeroActsLabel		= new JLabel ();
	m_PrintZeroActsBox			= new JCheckBox ();
	m_PrintZeroActsBox.addItemListener(this);
	
//	m_ShowMedTransPanelLabel		= new JLabel ();
//	m_ShowMedTransPanel			= new JCheckBox ();
//	m_ShowMedTransPanel.addItemListener(this);
	
	row = 0;
	m_InvoiceSettingsPanel.add (m_HospitalisationLabel,  			l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_Hospitalisation,   				l_Constraints.xywh(4, row,    3, 1));
	
	// MED TRANS Panel Disabled for now.....
//	m_InvoiceSettingsPanel.add (m_ShowMedTransPanelLabel,  			l_Constraints.xywh(2, row+=2, 1, 1));
//	m_InvoiceSettingsPanel.add (m_ShowMedTransPanel,   				l_Constraints.xywh(4, row,    3, 1));
	
	m_InvoiceSettingsPanel.add (m_ShowInfoColumnLabel,  			l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_ShowInfoColumn,   				l_Constraints.xywh(4, row,    3, 1));
	m_InvoiceSettingsPanel.add (m_ShowAdjustColumnLabel,  			l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_ShowAdjustColumnColumn,   		l_Constraints.xywh(4, row,    3, 1));
	m_InvoiceSettingsPanel.add (m_ShowMedPrescColumnLabel,  		l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_ShowMedPrescColumn,   			l_Constraints.xywh(4, row,    3, 1));
	m_InvoiceSettingsPanel.add (m_ShowUsernameColumnLabel,  		l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_ShowUsernameColumn,   			l_Constraints.xywh(4, row,    3, 1));
	m_InvoiceSettingsPanel.add (m_PrintCNSCodeLabel,  				l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_PrintCNSCodeBox,   				l_Constraints.xywh(4, row,    3, 1));
	m_InvoiceSettingsPanel.add (m_PrintZeroActsLabel,  				l_Constraints.xywh(2, row+=2, 1, 1));
	m_InvoiceSettingsPanel.add (m_PrintZeroActsBox,   				l_Constraints.xywh(4, row,    3, 1));
	//======================================================================
	//= Build Ruleengine Panel
	//======================================================================

	l_Layout							= new FormLayout(c_RuleengineColumns, c_RuleengineRows);
//	l_Constraints						= new CellConstraints();
			
	m_RuleengineSettingsPanel = createSubPanel("");
	m_RuleengineSettingsPanel.setLayout(l_Layout);
			
	m_HospitalCumulationModeLabel		= new JLabel();
	m_HospitalCumulationModeNormalBox	= new JRadioButton();
	m_HospitalCumulationModeFullFActBox	= new JRadioButton();
	m_HospitalCumulationModeFullBox		= new JRadioButton();
	
	ButtonGroup	bg	= new ButtonGroup();
	bg.add(m_HospitalCumulationModeNormalBox);
	bg.add(m_HospitalCumulationModeFullFActBox);
	bg.add(m_HospitalCumulationModeFullBox);
	
	m_SessionModeLabel					= new JLabel();
	m_SessionModeBox					= new JCheckBox();
	
	m_3PPValueLabel						= new JLabel();
	m_3PPValueField						= new NumericJTextField();
	
	row = 0;
	m_RuleengineSettingsPanel.add (m_HospitalCumulationModeLabel,		l_Constraints.xywh(2, row+=2, 1, 5));
	m_RuleengineSettingsPanel.add (m_HospitalCumulationModeNormalBox,	l_Constraints.xy(4, row));
	m_RuleengineSettingsPanel.add (m_HospitalCumulationModeFullFActBox,	l_Constraints.xy(4, row+=2));
	m_RuleengineSettingsPanel.add (m_HospitalCumulationModeFullBox,		l_Constraints.xy(4, row+=2));

	m_RuleengineSettingsPanel.add (m_SessionModeLabel,				l_Constraints.xy(2, row+=2));
	m_RuleengineSettingsPanel.add (m_SessionModeBox,				l_Constraints.xy(4, row));

	m_RuleengineSettingsPanel.add (m_3PPValueLabel,					l_Constraints.xy(2, row+=2));
	m_RuleengineSettingsPanel.add (m_3PPValueField,					l_Constraints.xy(4, row));
	
	//======================================================================
	//= Build Reminder Settings Panel
	//======================================================================

	l_Layout = new FormLayout(c_ReminderColumns, c_ReminderRows);
	l_Constraints  = new CellConstraints();
	
	m_ReminderSettingsPanel = createSubPanel("");
	m_ReminderSettingsPanel.setLayout(l_Layout);
	
	m_DuePeriodLabel 	= new JLabel ();
	m_DuePeriodUnit		= new JLabel ();
	m_DuePeriod 		= new JFormattedTextField (l_NumberFormat);
	
	m_OnlyExpiredInvoicesLabel 	= new JLabel ();
	m_OnlyExpiredInvoices 		= new JCheckBox ();

	m_PrintWithEachHeading = new JLabel ();
	
	l_SpinnerModel =	new SpinnerNumberModel (0,0,10,1);

	m_ReminderCopiesLabel  = new JLabel ();
	m_ReminderCopiesUnit   = new JLabel ();
	m_ReminderCopies       = new JSpinner (l_SpinnerModel);
		
	l_SpinnerModel =	new SpinnerNumberModel (0,0,10,1);
  	
	m_ReminderInvoicesLabel = new JLabel ();
	m_ReminderInvoicesUnit  = new JLabel ();
	m_ReminderInvoices      = new JSpinner (l_SpinnerModel);
	
	m_JoinReminderOfPatientLabel = new JLabel();
	m_JoinReminderOfPatient 	 = new JCheckBox(); 
	
	l_SpinnerModel =	new SpinnerNumberModel (0,0,10,1);

	m_PaymentOrderCopiesLabel  = new JLabel ();
	m_PaymentOrderCopiesUnit   = new JLabel ();
	m_PaymentOrderCopies       = new JSpinner (l_SpinnerModel);

	l_SpinnerModel =	new SpinnerNumberModel (0,0,10,1);

	m_PaymentOrderInvoicesLabel = new JLabel ();
	m_PaymentOrderInvoicesUnit  = new JLabel ();
	m_PaymentOrderInvoices      = new JSpinner (l_SpinnerModel);
	
	m_JoinPaymentOrdersOfPatientLabel 	= new JLabel();
	m_JoinPaymentOrdersOfPatient 		= new JCheckBox();
	
	m_ReminderSettingsPanel.add (m_DuePeriodLabel,  			l_Constraints.xywh(2, 2, 1, 1));
	m_ReminderSettingsPanel.add (m_DuePeriod,   				l_Constraints.xywh(4, 2, 1, 1));
	m_ReminderSettingsPanel.add (m_DuePeriodUnit,   			l_Constraints.xywh(6, 2, 1, 1));
	
	m_ReminderSettingsPanel.add (m_OnlyExpiredInvoicesLabel,  	l_Constraints.xywh(2, 4, 1, 1));
	m_ReminderSettingsPanel.add (m_OnlyExpiredInvoices,   		l_Constraints.xywh(4, 4, 1, 1));
	
	m_ReminderSettingsPanel.add (m_PrintWithEachHeading,  		l_Constraints.xywh(2, 6, 5, 1));
	
	m_ReminderSettingsPanel.add (m_ReminderCopiesLabel,  		l_Constraints.xywh(2, 8, 1, 1));
	m_ReminderSettingsPanel.add (m_ReminderCopies,   			l_Constraints.xywh(4, 8, 1, 1));
	m_ReminderSettingsPanel.add (m_ReminderCopiesUnit,   		l_Constraints.xywh(6, 8, 1, 1));
	
	m_ReminderSettingsPanel.add (m_ReminderInvoicesLabel,  		l_Constraints.xywh(2, 10, 1, 1));
	m_ReminderSettingsPanel.add (m_ReminderInvoices,   			l_Constraints.xywh(4, 10, 1, 1));
	m_ReminderSettingsPanel.add (m_ReminderInvoicesUnit,   		l_Constraints.xywh(6, 10, 1, 1));
	
	m_ReminderSettingsPanel.add(m_JoinReminderOfPatientLabel, 	l_Constraints.xywh(2, 12, 1, 1));
	m_ReminderSettingsPanel.add(m_JoinReminderOfPatient, 		l_Constraints.xywh(4, 12, 3, 1));
		
	m_ReminderSettingsPanel.add (m_PaymentOrderCopiesLabel,  	l_Constraints.xywh(2, 14, 1, 1));
	m_ReminderSettingsPanel.add (m_PaymentOrderCopies,   		l_Constraints.xywh(4, 14, 1, 1));
	m_ReminderSettingsPanel.add (m_PaymentOrderCopiesUnit,   	l_Constraints.xywh(6, 14, 1, 1));

	m_ReminderSettingsPanel.add (m_PaymentOrderInvoicesLabel,  	l_Constraints.xywh(2, 16, 1, 1));
	m_ReminderSettingsPanel.add (m_PaymentOrderInvoices,   		l_Constraints.xywh(4, 16, 1, 1));
	m_ReminderSettingsPanel.add (m_PaymentOrderInvoicesUnit,   	l_Constraints.xywh(6, 16, 1, 1));

//	m_ReminderSettingsPanel.add(m_JoinPaymentOrdersOfPatientLabel,l_Constraints.xywh(2, 18, 3, 1));
//	m_ReminderSettingsPanel.add(m_JoinPaymentOrdersOfPatient, 	l_Constraints.xywh(6, 18, 1, 1));
	
	
	//======================================================================
	//= Build ActCheck Settings Panel
	//======================================================================

	l_Layout = new FormLayout(
			"3dlu, pref:grow, 3dlu, pref, 3dlu, 20dlu, 3dlu",
			"3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
	l_Constraints  = new CellConstraints();
		
	m_ActCheckSettingsPanel = createSubPanel("");
	m_ActCheckSettingsPanel.setLayout(l_Layout);
	
	m_ActFutureLabel	= new JLabel ();
	m_ActCheckSettingsPanel.add (m_ActFutureLabel, 	l_Constraints.xy(2, 2));
	m_ActFuture			= new JCheckBox ();
	m_ActCheckSettingsPanel.add (m_ActFuture, 		l_Constraints.xy(4, 2));
	
	m_ActBeforeBirthLabel	= new JLabel ();
	m_ActCheckSettingsPanel.add (m_ActBeforeBirthLabel,l_Constraints.xy(2, 4));
	m_ActBeforeBirth		= new JCheckBox ();
	m_ActCheckSettingsPanel.add (m_ActBeforeBirth, 	l_Constraints.xy(4, 4));
	
	m_ActBirthdateCheckLabel	= new JLabel ();
	m_ActCheckSettingsPanel.add (m_ActBirthdateCheckLabel, 	l_Constraints.xy(2, 6));
	m_ActBirthdateCheck			= new JCheckBox ();
	m_ActCheckSettingsPanel.add (m_ActBirthdateCheck, 		l_Constraints.xy(4, 6));
	m_ActBirthdateMax			= new IntegerField();
	m_ActBirthdateMax.setEnabled(false);
	m_ActCheckSettingsPanel.add (m_ActBirthdateMax, 		l_Constraints.xy(6, 6));
	m_ActBirthdateCheck.addItemListener(new ItemListener() {
		public void itemStateChanged(ItemEvent e) {
			m_ActBirthdateMax.setEnabled(m_ActBirthdateCheck.isSelected());
		}
	});
	
	// -------------------------------------------------------------
	// Add all Panels
	// -------------------------------------------------------------	
	this.addSubPanel(m_BillingSettingsPanel);
	this.addSubPanel(m_InvoiceSettingsPanel);
	this.addSubPanel(m_RuleengineSettingsPanel);
	this.addSubPanel(m_ReminderSettingsPanel);
	this.addSubPanel(m_ActCheckSettingsPanel);
	
	
	setIcon(BillingModule.getIconResource("billing.png"));
	
	this.relocalize();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void revertToDefaults() 
	{
	Account	l_Account;
	
	m_SplitBilling.setSelected 				((Boolean) this.getDefault (BillingAdminSettings.c_SplitBillingSetting));
	m_ShortInvoiceNumbers.setSelected 		((Boolean) this.getDefault (BillingAdminSettings.c_ShortInvoiceNumbersSetting));
	m_UseLeadingZeros.setSelected 			((Boolean) this.getDefault (BillingAdminSettings.c_UseLeadingZerosSetting));
	m_Hospitalisation.setSelected 			((Boolean) this.getDefault (BillingAdminSettings.c_HospitalisationSetting));
//	m_CumulateAllIfHospitalized.setSelected	((Boolean) this.getDefault (BillingAdminSettings.c_CumulateAllIfHospitalized));
	setHospitalCumulationMode				((Integer)this.getDefault (BillingAdminSettings.c_HospitalizedCumulationMode));
	m_SessionModeBox.setSelected			((Boolean) this.getDefault (BillingAdminSettings.c_UseSessionMode));
	m_3PPValueField.setValue				((Integer) this.getDefault (BillingAdminSettings.c_TiersPayantMinValue));
	m_ThirdPartyStatements.setSelected 		((Boolean) this.getDefault (BillingAdminSettings.c_ThirdPartyStatementsSetting));
	m_MaxInvoices.setValue 					((Integer) this.getDefault (BillingAdminSettings.c_MaxInvoicesSetting));
	
	m_AddressStyle.setSelectedItem	  ((Integer) this.getDefault (BillingAdminSettings.c_AddressStyleSetting));
	
	l_Account = m_Accounts.get((Integer) this.getDefault (BillingAdminSettings.c_DefaultAccountIdSetting));
	if (l_Account != null) m_DefaultAccount.setSelectedItem(l_Account);
	
	m_DuePeriod.setValue			  		((Integer) this.getDefault (BillingAdminSettings.c_DuePeriodSetting));	
	m_OnlyExpiredInvoices.setSelected 		((Boolean) this.getDefault (BillingAdminSettings.c_OnlyExpiredInvoicesSetting));	
	m_ReminderCopies.setValue		  		(this.getDefault (BillingAdminSettings.c_ReminderCopiesSetting));
	m_ReminderInvoices.setValue		 		(this.getDefault (BillingAdminSettings.c_ReminderInvoicesSetting));
	m_PaymentOrderCopies.setValue	  		(this.getDefault (BillingAdminSettings.c_PaymentOrderCopiesSetting));
	m_PaymentOrderInvoices.setValue	  		(this.getDefault (BillingAdminSettings.c_PaymentOrderInvoicesSetting));
	m_JoinReminderOfPatient.setSelected		((Boolean)this.getDefault (BillingAdminSettings.c_JoinRemindersOfPatient));
	m_JoinPaymentOrdersOfPatient.setSelected((Boolean)this.getDefault (BillingAdminSettings.c_JoinPaymentOrdersOfPatient));
	
	m_ShowInfoColumn.setSelected			((Boolean)this.getDefault (BillingAdminSettings.c_ShowInfoColumnSetting));
	m_ShowMedPrescColumn.setSelected		((Boolean)this.getDefault (BillingAdminSettings.c_ShowMedPrescColumnSetting));
	m_ShowUsernameColumn.setSelected		((Boolean)this.getDefault (BillingAdminSettings.c_ShowUsernameColumnSetting));
	m_ShowAdjustColumnColumn.setSelected	((Boolean)this.getDefault (BillingAdminSettings.c_ShowAdjustColumnSetting));
	m_PrintCNSCodeBox.setSelected			((Boolean)this.getDefault (BillingAdminSettings.c_PrintCNSCodeSetting));
	m_PrintZeroActsBox.setSelected			((Boolean)this.getDefault (BillingAdminSettings.c_PrintZeroActsSetting));
//	m_ShowMedTransPanel.setSelected	((Boolean)this.getDefault (BillingAdminSettings.c_ShowMedTransPanelSetting));
	
	try {
		m_ActFuture.setSelected					((Boolean)this.getDefault (BillingAdminSettings.c_CheckActFuture));
		m_ActBeforeBirth.setSelected			((Boolean)this.getDefault (BillingAdminSettings.c_CheckActBeforeBirthDate));
		m_ActBirthdateCheck.setSelected			((Boolean)this.getDefault (BillingAdminSettings.c_CheckBirthDate));
		m_ActBirthdateMax.setValue				((Integer)this.getDefault (BillingAdminSettings.c_CheckBirthDateMax));		
	} catch (Exception e) {}
	
	enableRuleOptions();
	
	this.reflectSettings();
	super.revertToDefaults();
	}

//---------------------------------------------------------------------------

public void updateSettings() 
	{
	Account	l_Account;
	Integer	l_Style;
	
	this.setValue(BillingAdminSettings.c_SplitBillingSetting, 			(Boolean) m_SplitBilling.isSelected());
	this.setValue(BillingAdminSettings.c_ShortInvoiceNumbersSetting,	(Boolean) m_ShortInvoiceNumbers.isSelected());
	this.setValue(BillingAdminSettings.c_UseLeadingZerosSetting, 		(Boolean) m_UseLeadingZeros.isSelected());
	this.setValue(BillingAdminSettings.c_HospitalisationSetting, 		(Boolean) m_Hospitalisation.isSelected());
//	this.setValue(BillingAdminSettings.c_CumulateAllIfHospitalized, 	(Boolean) m_CumulateAllIfHospitalized.isSelected());
	this.setValue(BillingAdminSettings.c_HospitalizedCumulationMode, 	getHospitalCumulationMode());
	this.setValue(BillingAdminSettings.c_UseSessionMode, 				(Boolean) m_SessionModeBox.isSelected());
	this.setValue(BillingAdminSettings.c_TiersPayantMinValue, 			(Integer) Integer.valueOf(m_3PPValueField.getValue()));
	this.setValue(BillingAdminSettings.c_ThirdPartyStatementsSetting, 	(Boolean) m_ThirdPartyStatements.isSelected());
	
	if (m_MaxInvoices.getValue() instanceof Long)
		 this.setValue(BillingAdminSettings.c_MaxInvoicesSetting, (Integer)((Long)m_MaxInvoices.getValue()).intValue());
	else this.setValue(BillingAdminSettings.c_MaxInvoicesSetting, (Integer) m_MaxInvoices.getValue());

	l_Style = (Integer)m_AddressStyle.getSelectedItem();	
	if (l_Style != null)
		{
		this.setValue (BillingAdminSettings.c_AddressStyleSetting, l_Style);
		}
	
	l_Account = (Account)m_DefaultAccount.getSelectedItem();	
	if (l_Account != null)
		{
		this.setValue (BillingAdminSettings.c_DefaultAccountIdSetting, l_Account.getId());
//		this.setValue (BillingAdminSettings.c_DefaultAccountSetting, l_Account);
		}
		
	if (m_DuePeriod.getValue() instanceof Long)
		 this.setValue(BillingAdminSettings.c_DuePeriodSetting, (Integer)((Long)m_DuePeriod.getValue()).intValue());
	else this.setValue(BillingAdminSettings.c_DuePeriodSetting, (Integer) m_DuePeriod.getValue());

	this.setValue(BillingAdminSettings.c_OnlyExpiredInvoicesSetting, (Boolean) m_OnlyExpiredInvoices.isSelected());

	this.setValue(BillingAdminSettings.c_ReminderCopiesSetting, 	 	m_ReminderCopies.getValue());
	this.setValue(BillingAdminSettings.c_ReminderInvoicesSetting, 	 	m_ReminderInvoices.getValue());
	this.setValue(BillingAdminSettings.c_JoinRemindersOfPatient, 		m_JoinReminderOfPatient.isSelected());
	this.setValue(BillingAdminSettings.c_PaymentOrderCopiesSetting, 	m_PaymentOrderCopies.getValue());
	this.setValue(BillingAdminSettings.c_PaymentOrderInvoicesSetting, 	m_PaymentOrderInvoices.getValue());
	this.setValue(BillingAdminSettings.c_JoinPaymentOrdersOfPatient, 	m_JoinPaymentOrdersOfPatient.isSelected());
	
	this.setValue(BillingAdminSettings.c_ShowInfoColumnSetting, 		m_ShowInfoColumn.isSelected());
	this.setValue(BillingAdminSettings.c_ShowMedPrescColumnSetting, 	m_ShowMedPrescColumn.isSelected());
	this.setValue(BillingAdminSettings.c_ShowUsernameColumnSetting, 	m_ShowUsernameColumn.isSelected());
	this.setValue(BillingAdminSettings.c_ShowAdjustColumnSetting, 		m_ShowAdjustColumnColumn.isSelected());
	this.setValue(BillingAdminSettings.c_PrintCNSCodeSetting,			m_PrintCNSCodeBox.isSelected());
	this.setValue(BillingAdminSettings.c_PrintZeroActsSetting, 			m_PrintZeroActsBox.isSelected());
//	this.setValue(BillingAdminSettings.c_ShowMedTransPanelSetting, 		m_ShowMedTransPanel.isSelected());
	
	try {
		this.setValue(BillingAdminSettings.c_CheckActFuture, 			m_ActFuture.isSelected());
		this.setValue(BillingAdminSettings.c_CheckActBeforeBirthDate,	m_ActBeforeBirth.isSelected());
		this.setValue(BillingAdminSettings.c_CheckBirthDate, 			m_ActBirthdateCheck.isSelected());
		this.setValue(BillingAdminSettings.c_CheckBirthDateMax, 		m_ActBirthdateMax.getValue());		
	} catch (Exception e) {}
	
	super.updateSettings();
	}

//---------------------------------------------------------------------------

public void reflectSettings() 
	{
	Account	l_Account;
	
	super.reflectSettings();

	m_SplitBilling.setSelected 				((Boolean) this.getValue (BillingAdminSettings.c_SplitBillingSetting));
	m_ShortInvoiceNumbers.setSelected 		((Boolean) this.getValue (BillingAdminSettings.c_ShortInvoiceNumbersSetting));
	m_UseLeadingZeros.setSelected 			((Boolean) this.getValue (BillingAdminSettings.c_UseLeadingZerosSetting));
	m_Hospitalisation.setSelected 			((Boolean) this.getValue (BillingAdminSettings.c_HospitalisationSetting));
//	m_CumulateAllIfHospitalized.setSelected	((Boolean) this.getValue (BillingAdminSettings.c_CumulateAllIfHospitalized));
	setHospitalCumulationMode				((Integer)this.getValue(BillingAdminSettings.c_HospitalizedCumulationMode));
//	m_HospitalCumulationModeNormalBox;
//	m_HospitalCumulationModeFullFActBox;
//	m_HospitalCumulationModeFullBox;
	m_SessionModeBox.setSelected			((Boolean) this.getValue (BillingAdminSettings.c_UseSessionMode));
	m_3PPValueField.setValue				((Integer) this.getValue (BillingAdminSettings.c_TiersPayantMinValue));
	m_ThirdPartyStatements.setSelected 		((Boolean) this.getValue (BillingAdminSettings.c_ThirdPartyStatementsSetting));

	m_AddressStyle.setSelectedItem ((Integer)this.getValue (BillingAdminSettings.c_AddressStyleSetting));
	
	l_Account = m_Accounts.get((Integer) this.getValue (BillingAdminSettings.c_DefaultAccountIdSetting));
	if (l_Account != null) m_DefaultAccount.setSelectedItem(l_Account);

	if (this.getValue (BillingAdminSettings.c_MaxInvoicesSetting) instanceof Long)
		 m_MaxInvoices.setValue ((Integer)((Long)this.getValue (BillingAdminSettings.c_MaxInvoicesSetting)).intValue());
	else m_MaxInvoices.setValue			  ((Integer) this.getValue (BillingAdminSettings.c_MaxInvoicesSetting));	
	
	if (this.getValue (BillingAdminSettings.c_DuePeriodSetting) instanceof Long)
		 m_DuePeriod.setValue ((Integer)((Long)this.getValue (BillingAdminSettings.c_DuePeriodSetting)).intValue());
	else m_DuePeriod.setValue			((Integer) this.getValue (BillingAdminSettings.c_DuePeriodSetting));	

	m_OnlyExpiredInvoices.setSelected ((Boolean) this.getValue (BillingAdminSettings.c_OnlyExpiredInvoicesSetting));	
	
	m_ReminderCopies.setValue				(this.getValue (BillingAdminSettings.c_ReminderCopiesSetting));
	m_ReminderInvoices.setValue				(this.getValue (BillingAdminSettings.c_ReminderInvoicesSetting));
	m_PaymentOrderCopies.setValue			(this.getValue (BillingAdminSettings.c_PaymentOrderCopiesSetting));
	m_PaymentOrderInvoices.setValue			(this.getValue (BillingAdminSettings.c_PaymentOrderInvoicesSetting));
	m_JoinReminderOfPatient.setSelected		((Boolean)this.getValue(BillingAdminSettings.c_JoinRemindersOfPatient));
	m_JoinPaymentOrdersOfPatient.setSelected((Boolean)this.getValue(BillingAdminSettings.c_JoinPaymentOrdersOfPatient));
	
	m_ShowInfoColumn.setSelected		((Boolean)this.getValue (BillingAdminSettings.c_ShowInfoColumnSetting));
	m_ShowMedPrescColumn.setSelected	((Boolean)this.getValue (BillingAdminSettings.c_ShowMedPrescColumnSetting));
	m_ShowUsernameColumn.setSelected	((Boolean)this.getValue (BillingAdminSettings.c_ShowUsernameColumnSetting));
	m_ShowAdjustColumnColumn.setSelected((Boolean)this.getValue (BillingAdminSettings.c_ShowAdjustColumnSetting));
//	m_ShowMedTransPanel.setSelected	((Boolean)this.getValue (BillingAdminSettings.c_ShowMedTransPanelSetting));
	m_PrintCNSCodeBox.setSelected		((Boolean)this.getValue (BillingAdminSettings.c_PrintCNSCodeSetting));
	m_PrintZeroActsBox.setSelected		((Boolean)this.getValue (BillingAdminSettings.c_PrintZeroActsSetting));
	
	try {
		m_ActFuture.setSelected					((Boolean)this.getValue (BillingAdminSettings.c_CheckActFuture));
		m_ActBeforeBirth.setSelected			((Boolean)this.getValue (BillingAdminSettings.c_CheckActBeforeBirthDate));
		m_ActBirthdateCheck.setSelected			((Boolean)this.getValue (BillingAdminSettings.c_CheckBirthDate));
		m_ActBirthdateMax.setValue				((Integer)this.getValue (BillingAdminSettings.c_CheckBirthDateMax));		
	} catch (Exception e) {}
	
	enableRuleOptions();
	}

//---------------------------------------------------------------------------

public void setStationaryValues() 
	{
	setStationary(BillingAdminSettings.c_SplitBillingSetting, 			c_SplitBillingStationary);
	setStationary(BillingAdminSettings.c_ShortInvoiceNumbersSetting, 	c_ShortInvoiceNumbersStationary);
	setStationary(BillingAdminSettings.c_UseLeadingZerosSetting, 		c_UseLeadingZerosStationary);
	setStationary(BillingAdminSettings.c_HospitalisationSetting, 		c_HospitalisationStationary);
//	setStationary(BillingAdminSettings.c_CumulateAllIfHospitalized, 	c_CumulateAllIfHospStationary);
	setStationary(BillingAdminSettings.c_HospitalizedCumulationMode, 	c_HospitalizedCumulationStationary);
	setStationary(BillingAdminSettings.c_UseSessionMode, 				c_UseSessionModeStationary);
	setStationary(BillingAdminSettings.c_TiersPayantMinValue, 			c_TiersPayantMinValueStationary);
	setStationary(BillingAdminSettings.c_ThirdPartyStatementsSetting, 	c_ThirdPartyStatementsStationary);
	setStationary(BillingAdminSettings.c_MaxInvoicesSetting, 			c_MaxInvoicesStationary);
	setStationary(BillingAdminSettings.c_DefaultAccountIdSetting, 		c_DefaultAccountIdStationary);
	setStationary(BillingAdminSettings.c_AddressStyleSetting,			c_AddressStyleStationary);
//	setStationary(BillingAdminSettings.c_DefaultAccountSetting,			this.getAccountByID(c_DefaultAccountIdStationary));
	setStationary(BillingAdminSettings.c_DuePeriodSetting, 				c_DuePeriodStationary);
	setStationary(BillingAdminSettings.c_OnlyExpiredInvoicesSetting, 	c_OnlyExpiredInvoicesStationary);
	setStationary(BillingAdminSettings.c_ReminderCopiesSetting, 		c_ReminderCopiesStationary);
	setStationary(BillingAdminSettings.c_ReminderInvoicesSetting, 		c_ReminderInvoicesStationary);
	setStationary(BillingAdminSettings.c_JoinRemindersOfPatient, 		c_JoinRemindersStationary);
	setStationary(BillingAdminSettings.c_PaymentOrderCopiesSetting, 	c_PaymentOrderCopiesStationary);
	setStationary(BillingAdminSettings.c_PaymentOrderInvoicesSetting, 	c_PaymentOrderInvoicesStationary);
	setStationary(BillingAdminSettings.c_JoinPaymentOrdersOfPatient, 	c_JoinPaymentOrdersStationary);
	
	setStationary(BillingAdminSettings.c_ShowInfoColumnSetting, 		c_ShowInfoColumn);
	setStationary(BillingAdminSettings.c_ShowMedPrescColumnSetting, 	c_ShowMedPrescColumn);
	setStationary(BillingAdminSettings.c_ShowUsernameColumnSetting, 	c_ShowInfoColumn);
	setStationary(BillingAdminSettings.c_ShowAdjustColumnSetting, 		c_ShowMedPrescColumn);
	setStationary(BillingAdminSettings.c_ShowMedTransPanelSetting, 		c_ShowMedTransPanel);
	
	setStationary(BillingAdminSettings.c_PrintCNSCodeSetting,			BillingAdminSettings.c_PrintPhysicianCNSNoStationary);
	setStationary(BillingAdminSettings.c_PrintZeroActsSetting,			BillingAdminSettings.c_PrintZeroActsStationary);
	
	setStationary(BillingAdminSettings.c_CheckActFuture,				BillingAdminSettings.c_CheckActFutureStationary);
	setStationary(BillingAdminSettings.c_CheckActBeforeBirthDate,		BillingAdminSettings.c_CheckActBeforeBirthDateStationary);
	setStationary(BillingAdminSettings.c_CheckBirthDate,				BillingAdminSettings.c_CheckBirthDateStationary);
	setStationary(BillingAdminSettings.c_CheckBirthDateMax,				BillingAdminSettings.c_CheckBirthDateMaxStationary);
	
	}

//---------------------------------------------------------------------------

public void relocalize() 
	{
	super.relocalize();
	
	this.setLabel(Translatrix._("BillingAdminSettingsPlugin.Title"));
	this.setSubPanelTitle (m_BillingSettingsPanel, Translatrix._("BillingAdminSettingsPlugin.BillingSettingsTitle"));
	this.setSubPanelTitle (m_InvoiceSettingsPanel, Translatrix._("BillingAdminSettingsPlugin.InvoiceSettingsTitle"));
	this.setSubPanelTitle (m_RuleengineSettingsPanel, Translatrix._("BillingAdminSettingsPlugin.RuleengineSettingsTitle"));
	this.setSubPanelTitle (m_ReminderSettingsPanel, Translatrix._("BillingAdminSettingsPlugin.ReminderSettingsTitle"));
	this.setSubPanelTitle (m_ActCheckSettingsPanel, Translatrix._("BillingAdminSettingsPlugin.ActCheckSettingsTitle"));
	
	
	m_SplitBillingLabel.setText(Translatrix._("BillingAdminSettingsPlugin.BillingPerPhysician"));
	m_ShortInvoiceNumbersLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ShortInvoiceNumbers"));
	m_UseLeadingZerosLabel.setText(Translatrix._("BillingAdminSettingsPlugin.UseLeadingZeros"));
	m_HospitalisationLabel.setText(Translatrix._("BillingAdminSettingsPlugin.Hospitalisation"));
	m_HospitalCumulationModeLabel.setText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationMode"));
	m_HospitalCumulationModeLabel.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeToolTip"));
	m_HospitalCumulationModeNormalBox.setText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeNormal"));
	m_HospitalCumulationModeNormalBox.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeNormalToolTip"));
	m_HospitalCumulationModeFullFActBox.setText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeUnlimitedWithFCode"));
	m_HospitalCumulationModeFullFActBox.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeUnlimitedWithFCodeToolTip"));
	m_HospitalCumulationModeFullBox.setText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeUnlimited"));
	m_HospitalCumulationModeFullBox.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.HospitalCumulationModeUnlimitedToolTip"));
	m_SessionModeLabel.setText(Translatrix._("BillingAdminSettingsPlugin.SessionMode"));
	m_SessionModeLabel.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.SessionModeToolTip"));
	m_SessionModeBox.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.SessionModeToolTip"));
	m_3PPValueLabel.setText(Translatrix._("BillingAdminSettingsPlugin.3PPValue"));
	m_3PPValueLabel.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.3PPValueToolTip"));
	m_3PPValueField.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.3PPValueToolTip"));
	m_ThirdPartyStatementsLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ThirdPartyStatements"));
	
	m_MaxInvoicesLabel.setText(Translatrix._("BillingAdminSettingsPlugin.MaxInvoicesLabel"));
	m_MaxInvoicesUnit.setText(Translatrix._("BillingAdminSettingsPlugin.InvoicesUnit"));
	
	m_AddressStyleLabel.setText(Translatrix._("BillingAdminSettingsPlugin.AddressStyleLabel"));
	
	m_DefaultAccountLabel.setText(Translatrix._("BillingAdminSettingsPlugin.DefaultAccountLabel"));

	m_DuePeriodLabel.setText(Translatrix._("BillingAdminSettingsPlugin.DuePeriodLabel"));
	m_DuePeriodUnit.setText(Translatrix._("BillingAdminSettingsPlugin.DaysUnit"));
	m_OnlyExpiredInvoicesLabel.setText(Translatrix._("BillingAdminSettingsPlugin.OnlyExpiredInvoicesLabel"));
	
	m_PrintWithEachHeading.setText(Translatrix._("BillingAdminSettingsPlugin.PrintWithEachHeading"));
	
	m_ReminderCopiesLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ReminderCopiesLabel"));
	m_ReminderCopiesUnit.setText(Translatrix._("BillingAdminSettingsPlugin.CopiesUnit"));
	
	m_ReminderInvoicesLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ReminderInvoicesLabel"));
	m_ReminderInvoicesUnit.setText(Translatrix._("BillingAdminSettingsPlugin.InvoicesUnit"));
	
	m_JoinReminderOfPatientLabel.setText(Translatrix._("BillingAdminSettingsPlugin.JoinRemindersOfPatient"));
	
	m_PaymentOrderCopiesLabel.setText(Translatrix._("BillingAdminSettingsPlugin.PaymentOrderCopiesLabel"));
	m_PaymentOrderCopiesUnit.setText(Translatrix._("BillingAdminSettingsPlugin.CopiesUnit"));

	m_PaymentOrderInvoicesLabel.setText(Translatrix._("BillingAdminSettingsPlugin.PaymentOrderInvoicesLabel"));
	m_PaymentOrderInvoicesUnit.setText(Translatrix._("BillingAdminSettingsPlugin.InvoicesUnit"));
	
	m_JoinPaymentOrdersOfPatientLabel.setText(Translatrix._("BillingAdminSettingsPlugin.JoinPaymentOrdersOfPatient"));
	
	m_ShowInfoColumnLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ShowInfoColumn"));
	m_ShowMedPrescColumnLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ShowMedPrescColumn"));
	m_ShowUsernameColumnLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ShowUsernameColumn"));
	m_ShowAdjustColumnLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ShowAdjustColumn"));
	m_PrintCNSCodeLabel.setText(Translatrix._("BillingAdminSettingsPlugin.PrintCNSCode"));
	m_PrintCNSCodeLabel.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.PrintCNSCodeToolTip"));
	m_PrintCNSCodeBox.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.PrintCNSCodeToolTip"));
	m_PrintZeroActsLabel.setText(Translatrix._("BillingAdminSettingsPlugin.PrintZeroActs"));
	m_PrintZeroActsLabel.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.PrintZeroActsToolTip"));
	m_PrintZeroActsBox.setToolTipText(Translatrix._("BillingAdminSettingsPlugin.PrintZeroActsToolTip"));
//	m_ShowMedTransPanelLabel.setText(Translatrix._("BillingAdminSettingsPlugin.ShowMedTransPanel"));
		
	m_ActFutureLabel.setText(			Translatrix._("BillingAdminSettingsPlugin.ActFutureLabel"));
	m_ActBeforeBirthLabel.setText(		Translatrix._("BillingAdminSettingsPlugin.ActBeforeBirthLabel"));
	m_ActBirthdateCheckLabel.setText(	Translatrix._("BillingAdminSettingsPlugin.ActBirthdateCheckLabel"));
	
	
	}

public void itemStateChanged (ItemEvent e)
{
	if (e.getSource() == m_Hospitalisation)
	{
		enableRuleOptions();
	}
}

private void enableRuleOptions ()
{
	if (m_Hospitalisation.isSelected())
	{
//		Boolean selected;
//		Integer	value;
		
		
//		m_CumulateAllIfHospitalized.setEnabled(true);
		m_HospitalCumulationModeNormalBox.setEnabled(true);
		m_HospitalCumulationModeFullFActBox.setEnabled(true);
		m_HospitalCumulationModeFullBox.setEnabled(true);
		m_HospitalCumulationModeLabel.setEnabled(true);
		m_SessionModeBox.setEnabled(true);
		m_SessionModeLabel.setEnabled(true);
		m_3PPValueField.setEnabled(true);
		m_3PPValueLabel.setEnabled(true);
		
//		selected = (Boolean) getValue(BillingAdminSettings.c_CumulateAllIfHospitalized);
//		if (selected == null)
//			selected = BillingAdminSettings.c_CumulateAllIfHospitalizedDefault;
//		m_CumulateAllIfHospitalized.setSelected(selected);
//		
//		selected = (Boolean) getValue(BillingAdminSettings.c_UseSessionMode);
//		if (selected == null)
//			selected = BillingAdminSettings.c_UseSessionModeDefault;
//		m_SessionModeBox.setSelected(selected);
//
//		value = (Integer) getValue(BillingAdminSettings.c_TiersPayantMinValue);
//		if (value == null)
//			value = BillingAdminSettings.c_TiersPayantMinValueDefault;
//		m_3PPValueField.setValue(value.intValue());
	}
	else
	{
		m_HospitalCumulationModeLabel.setEnabled(false);
		m_HospitalCumulationModeNormalBox.setEnabled(false);
		m_HospitalCumulationModeFullFActBox.setEnabled(false);
		m_HospitalCumulationModeFullBox.setEnabled(false);
		m_SessionModeLabel.setEnabled(false);
		m_SessionModeBox.setEnabled(false);
		m_3PPValueLabel.setEnabled(false);
		m_3PPValueField.setEnabled(false);
	}
}


private void setHospitalCumulationMode (Integer l_Value)
{
	Boolean	l_OldValue;
	
	if (l_Value == null)
	{
		l_OldValue	= (Boolean) this.getValue(BillingAdminSettings.c_CumulateAllIfHospitalized);
		if (l_OldValue == null)
			l_Value	= (Integer) getDefault(BillingAdminSettings.c_HospitalizedCumulationMode);
		else if (l_OldValue.booleanValue())
			l_Value	= Integer.valueOf(BillingAdminSettings.c_HospitalizedCumulationModeFull);
		else
			l_Value	= Integer.valueOf(BillingAdminSettings.c_HospitalizedCumulationModeNormal);
	}
	
	switch (((Integer)l_Value).intValue())
	{
		case BillingAdminSettings.c_HospitalizedCumulationModeNormal:
			m_HospitalCumulationModeNormalBox.setSelected(true);
			break;
			
		case BillingAdminSettings.c_HospitalizedCumulationModeFullWithFCode:
			m_HospitalCumulationModeFullFActBox.setSelected(true);
			break;
			
		case BillingAdminSettings.c_HospitalizedCumulationModeFull:
			m_HospitalCumulationModeFullBox.setSelected(true);
			break;
	}
}


private int getHospitalCumulationMode ()
{
	if (m_HospitalCumulationModeNormalBox.isSelected())
		return BillingAdminSettings.c_HospitalizedCumulationModeNormal;
	else if (m_HospitalCumulationModeFullFActBox.isSelected())
		return BillingAdminSettings.c_HospitalizedCumulationModeFullWithFCode;
	else if (m_HospitalCumulationModeFullBox.isSelected())
		return BillingAdminSettings.c_HospitalizedCumulationModeFull;
	else
		return ((Integer)getDefault(BillingAdminSettings.c_HospitalizedCumulationMode)).intValue();
}


//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
}
