/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.config;

import java.awt.Color;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;


/**
 * a renderer for Insurance objects in comboboxes
 *
 * @author Nico MACK
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class AccountComboBoxRenderer extends DefaultComboBoxRenderer
{
	private int 	m_DisplayMask;
	private String m_HTMLTemplate;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
    private static final long serialVersionUID = 1L;

    public static final int c_BankName = 0x01;
    public static final int c_IBAN		= 0x02;
    public static final int c_BIC		= 0x04;
    
    public static final String c_BankPlaceHolder = "_BANK_";
    public static final String c_IBANPlaceHolder = "_IBAN_";
    public static final String c_BICPlaceHolder  = "_BIC_";
     
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public AccountComboBoxRenderer (int p_DisplayMask)
	{
	m_DisplayMask 	= p_DisplayMask;
	m_HTMLTemplate 	= null;
	}

//---------------------------------------------------------------------------

public AccountComboBoxRenderer (String p_HTMLTemplate)
	{
	m_HTMLTemplate = p_HTMLTemplate;
	m_DisplayMask  = 0;
	}

//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private String renderFromMask (Account p_Account)
	{
    String	l_RenderString = "";
	String	l_Spacer = "";

	if ((m_DisplayMask & c_BankName) == c_BankName)
		{
		l_RenderString += l_Spacer + p_Account.getBankname();
		l_Spacer = " ";
		}
	   
	if ((m_DisplayMask & c_IBAN) == c_IBAN)
		{
		l_RenderString += l_Spacer + p_Account.getIban();
		l_Spacer = " ";
		}
	   
	if ((m_DisplayMask & c_BIC) == c_BIC)
		{
		l_RenderString += l_Spacer + p_Account.getBic();
		l_Spacer = " ";
		}
	
	return l_RenderString;
	}

//---------------------------------------------------------------------------

private String renderFromHTMLTemplate (Account p_Account)
	{
	String	l_RenderString;
	
	if (m_HTMLTemplate == null) return "";
	
	l_RenderString = m_HTMLTemplate;
	
	l_RenderString = l_RenderString.replaceAll(c_BankPlaceHolder, p_Account.getBankname());
	l_RenderString = l_RenderString.replaceAll(c_IBANPlaceHolder, p_Account.getIban());
	l_RenderString = l_RenderString.replaceAll(c_BICPlaceHolder,  p_Account.getBic());
	
	return l_RenderString;
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void setEnabled (boolean p_EnableIt)
	{
	if (p_EnableIt)
		 this.setForeground (Color.BLACK);
	else this.setForeground (Color.LIGHT_GRAY);
	}

//---------------------------------------------------------------------------

protected String getRenderString (Object p_Object)
    {
	Account l_Account;
    
	if (p_Object instanceof Account)
		{
		l_Account = (Account) p_Object;
	
		if (m_DisplayMask > 0) 
			 return this.renderFromMask(l_Account);
		else return this.renderFromHTMLTemplate(l_Account);
		}
	return "";
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
