/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Relocalizer;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

//***************************************************************************
//* Class Definition and Members	                                        *
//***************************************************************************

public class NomenclaturePanel extends GECAMedTab implements Relocalizable 
	{
	private static final long serialVersionUID = 1L;

	private KeyValuePanel		m_KeyValuePanel = null;
	private RatesPanel			m_RatesPanel	= null;
	private boolean				m_Build			= false;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
	private final static String c_Columns= 	"3dlu,fill:max(350dlu;pref),3dlu,fill:pref:grow,3dlu";
	
	private final static String c_Rows=    	"3dlu,150dlu,3dlu,fill:pref:grow,3dlu";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public NomenclaturePanel ()
	{
	FormLayout	l_Layout;	
	
	l_Layout = new FormLayout(c_Columns, c_Rows);

	this.setLayout(l_Layout);	
	this.setOpaque(false);
	this.setTitle(Translatrix.getTranslationString ("NomenclaturePanel.Title"));
//	this.setIcon (BillingModule.getIconResource ("nomenclature.png"));
	this.setIcon (BillingModule.getIconResource ("cns_logo.png"));
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private void buildPanel ()
	{
	CellConstraints	l_Constraints;
	
	l_Constraints  	= new CellConstraints();
	
	m_KeyValuePanel = new KeyValuePanel ();	
	m_RatesPanel    = new RatesPanel ();
	
	m_KeyValuePanel.addKeyValueListener (m_RatesPanel);
	
	this.add (m_KeyValuePanel, 	  l_Constraints.xywh(2, 2, 1, 1));
	this.add (m_RatesPanel, 	  l_Constraints.xywh(2, 4, 3, 1));	
	
	m_Build = true;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void preparetoShowup()
	{
	if (!m_Build) this.buildPanel();
	}

//---------------------------------------------------------------------------

public void enablePanel (boolean p_EnableIt) 
	{
	}

//---------------------------------------------------------------------------

public void relocalize()
	{
	Relocalizer.relocalizeChildren (this);		
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Clas                                                             *
//***************************************************************************
//---------------------------------------------------------------------------

}
