/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.util.Date;

import javax.swing.tree.TreePath;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;
import lu.tudor.santec.i18n.Translatrix;

import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class KeyValueTreeTableModel extends DefaultTreeTableModel
	{
 	public static final Date c_Epoch = new Date (0);
 	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
    
 	public static final String c_LabelHeader 			= "KeyValueListModel.LabelHeader";
	public static final String c_TypeHeader 			= "KeyValueListModel.TypeHeader";
    public static final String c_ApplicableDateHeader	= "KeyValueListModel.ApplicableDateHeader";
    public static final String c_ValueHeader			= "KeyValueListModel.ValueHeader";
       
    public static final int    c_LabelColumn 			= 0;
    public static final int    c_TypeColumn 			= 1;
    public static final int    c_ApplicableDateColumn	= 2;
    public static final int    c_ValueColumn			= 3;
     
    static final public String c_TableHeaders [] = {  	c_LabelHeader,
    													c_TypeHeader,
    													c_ApplicableDateHeader,
    													c_ValueHeader };
 	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public  KeyValueTreeTableModel ()
	{
	super(new KeyValueTreeNode ());
	}
    
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
		{
		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (1);
    }


//---------------------------------------------------------------------------

public Object getValueAt (Object p_Node, int p_Column)
	{
	KeyValue l_KeyVal;
	
	if (p_Node instanceof KeyValueTreeNode)
		{
		l_KeyVal = ((KeyValueTreeNode)p_Node).getKeyValue();
		if (l_KeyVal != null)
			{
			switch (p_Column)
				{
				case c_LabelColumn: 		return (l_KeyVal.getLabel() != null) ? l_KeyVal.getLabel() : "";       
				case c_TypeColumn:			return (l_KeyVal.getKeyType()  != null) ? l_KeyVal.getKeyType()  : "";
				case c_ApplicableDateColumn:return (l_KeyVal.getApplicability() != null)   ? l_KeyVal.getApplicability()   : c_Epoch;
				case c_ValueColumn: 		return (l_KeyVal.getValue() != null)   ? l_KeyVal.getValue()   : Double.valueOf(0.0);
				}
			}
		}

	return "";		
	}

//---------------------------------------------------------------------------

public Class<?> getColumnClass (int p_Column)
	{
	KeyValueTreeNode	l_Node;
	
	l_Node = new KeyValueTreeNode ();
	return this.getValueAt(l_Node, p_Column).getClass();	
	}

//---------------------------------------------------------------------------

public boolean isCellEditable (Object p_Node, int p_Column)
	{
	return false;
	}

//---------------------------------------------------------------------------

public int getChildCount (Object p_Node)
	{
	KeyValueTreeNode l_Node;	
		
	if (p_Node instanceof KeyValueTreeNode)
		{
		l_Node = (KeyValueTreeNode) p_Node;
		return l_Node.getChildCount();
		}
	else return 0;
	}

//---------------------------------------------------------------------------

public Object getChild (Object p_Node, int p_Index)
	{
	KeyValueTreeNode l_Node;	
		
	if (p_Node instanceof KeyValueTreeNode)
		{
		l_Node = (KeyValueTreeNode) p_Node;
		return l_Node.getChildAt(p_Index);
		}
	else return null;
	}

//---------------------------------------------------------------------------

public int getIndexOfChild (Object p_Parent, Object p_Child)
	{
	KeyValueTreeNode l_Parent;	
	KeyValueTreeNode l_Child;	

	if (	(p_Parent instanceof KeyValueTreeNode)
		 && (p_Child instanceof KeyValueTreeNode))
		{
		l_Parent = (KeyValueTreeNode) p_Parent;
		l_Child  = (KeyValueTreeNode) p_Child;
		return l_Parent.getIndex (l_Child);
		}	
	else return 0;
	}

//---------------------------------------------------------------------------

public boolean isLeaf (Object p_Node)
	{
	KeyValueTreeNode l_Node;	
		
	if (p_Node instanceof KeyValueTreeNode)
		{
		l_Node = (KeyValueTreeNode) p_Node;
		return l_Node.isLeaf();
		}
	else return false;
	}

//---------------------------------------------------------------------------

public TreeTableNode getRoot()
	{	
	return super.getRoot();
	}

//---------------------------------------------------------------------------

public void setRoot (RateTreeNode p_RootNode)
	{
	RateTreeNode l_Root	= (RateTreeNode) super.getRoot();
	if (l_Root != null) l_Root.removeAllChildren();
	
	super.setRoot(p_RootNode);
	}

//---------------------------------------------------------------------------

public void nodeChanged (RateTreeNode node)
	{
	TreeTableNode	parent		= node.getParent();
	TreePath		parentPath	= new TreePath(getPathToRoot(parent));
	int				index		= parent.getIndex(node);
	
	modelSupport.fireChildChanged(parentPath, index, node);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Clas                                                             *
//***************************************************************************
//---------------------------------------------------------------------------
	}
