/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.text.NumberFormat;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.tree.TreePath;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.KeyValue;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericRenderer;

import org.jdesktop.swingx.JXTreeTable;

public class KeyValueRenderer extends GenericRenderer
	{
	private static final long serialVersionUID = 1L;
	
	private NumberFormat			m_KeyValueFormat;
	private Date					m_Today;
	private JXTreeTable 			m_Table;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new instance of KeyValueRenderer
 */
//---------------------------------------------------------------------------

public KeyValueRenderer (JXTreeTable table)
	{
	super ();
	
	m_Table = table;
	m_KeyValueFormat = NumberFormat.getNumberInstance();
	m_KeyValueFormat.setMinimumFractionDigits(5);
	m_KeyValueFormat.setMaximumFractionDigits(5);
	m_Today = new Date ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns a properly formatted string for the specfied value.
 * @param p_Value specifies the numeric value to be formatted.
 * @return a properly formatted string representation of the specified
 * value. If specified value was <code>null</code> the method will return
 * a string as if the value 0 was specified.
 */
//---------------------------------------------------------------------------

private String formatKeyValue (Double p_Value)
	{
	if (p_Value != null)
		 return m_KeyValueFormat.format (p_Value);
	else return m_KeyValueFormat.format (GenericRenderer.c_Zero);	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	JLabel      l_Label;
	KeyValue	l_KeyValue = null;
	int			l_Column;
	
	l_Label = (JLabel) super.getTableCellRendererComponent(p_Table, p_Value, 
													           p_IsSelected, p_HasFocus, 
													           p_Row, p_Column);
	
	
	if ((p_Value != null))
		{
		l_Column = this.modelColumn(p_Table, p_Column);
					
		TreePath l_SelectionPath = m_Table.getPathForRow (p_Row);
		KeyValueTreeNode l_Node = (KeyValueTreeNode) l_SelectionPath.getLastPathComponent();
		l_KeyValue = l_Node.getKeyValue();
		
		switch (l_Column)
			{
			case KeyValueTreeTableModel.c_LabelColumn:
				l_Label.setHorizontalAlignment (SwingConstants.LEFT);
				l_Label.setText (p_Value + "");
				break;
				
			case KeyValueTreeTableModel.c_TypeColumn:
				
				l_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Label.setText(p_Value+"");
				break;
			case KeyValueTreeTableModel.c_ApplicableDateColumn:
				
				l_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Label.setText(this.formatDate((Date) p_Value));
				break;
				
			case KeyValueTreeTableModel.c_ValueColumn:
				
				l_Label.setHorizontalAlignment (SwingConstants.CENTER);
				l_Label.setText(this.formatKeyValue((Double) p_Value));
				
				if (l_KeyValue != null) {
					try {
						if (l_KeyValue.getApplicability().after(m_Today)) {
							l_Label.setForeground(Color.ORANGE);
						} else if ( isNodeOutdated(l_Node) ) {
							l_Label.setForeground(Color.GRAY);
						} else {
							l_Label.setForeground(Color.GREEN.darker());
						}						
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				break;
			}	
		}
	
	return l_Label;
	}

	private boolean isNodeOutdated(KeyValueTreeNode l_Node) {
		KeyValueTreeNode l_Parent = (KeyValueTreeNode) l_Node.getParent();
		if (l_Parent.getKeyValue() != null ) {
			Date fromDate = l_Parent.getKeyValue().getApplicability();
			if (fromDate.before(m_Today))
				return true;
		}
		
		for (int i = 0; i < l_Parent.getChildCount(); i++) {
			KeyValueTreeNode l_OtherNode = (KeyValueTreeNode) l_Parent.getChildAt(i);
			Date otherFromDate = l_OtherNode.getKeyValue().getApplicability();
			
			if (! l_OtherNode.getKeyValue().getKeyType().equals(l_Node.getKeyValue().getKeyType())) {
				continue;
			}
			
			if (otherFromDate.before(m_Today)) {
				if ( ! l_OtherNode.equals(l_Node) ) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
		return false;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
