/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.ejb.session.beans.SettlementBean;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.SettlementInterface;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

public class AccountsTableModel extends AbstractTableModel {
 	private static final long serialVersionUID = 1L;

	private static Logger m_Logger = Logger.getLogger ("lu.tudor.santec.gecamed.billing.gui.admin.AccountsTableModel");

	private final static String[] columns = {"Obsolete",
		Translatrix.getTranslationString("AccountPanel.accountname"),
		Translatrix.getTranslationString("AccountPanel.bankname"),
		Translatrix.getTranslationString("AccountPanel.iban"),
		Translatrix.getTranslationString("AccountPanel.bic")
	};
 	
	private Class[] columnsClasses = {
	    	Boolean.class,
	    	String.class,
			String.class,
			String.class,
			String.class
	};
	private Vector<Settlement> settlements = new Vector<Settlement>();

	@Override
	public Class<?> getColumnClass(int column) {
		return getValueAt(0, column).getClass();
	}

	
	private SettlementInterface settlementInterface;

//	private boolean editable;

	public AccountsTableModel() {
		try {
			settlementInterface = (SettlementInterface) ManagerFactory.getRemote(SettlementBean.class);
// 			InitialContext l_Context = new InitialContext();
// 			settlementInterface = (SettlementInterface) l_Context.lookup("SettlementBean/remote");
// 			l_Context.close();
		} 
 		catch (Exception p_Exception) {
 			m_Logger.warn(p_Exception.getLocalizedMessage());
 		}
 	}

 	
	public int getRowCount() {
		return settlements.size();
	}

	public int getColumnCount() {
		return columns.length;
	}
	
	@Override
	public String getColumnName(int column) {
		return columns[column];
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		
		
		if (rowIndex == -1) 
			return null;
		
		Account ac;
		try {
			ac = settlements.get(rowIndex).getTransferAccount();
		} catch (Exception e) {
			e.printStackTrace();
			return "";
		}
		switch (columnIndex) {
		case 0:
			if(ac.getObsolete()!=null) {
				if(ac.getObsolete()) {	
					return true;	
				} else {
					return false;
				}
			}
			return false;
				
		case 1:
			return ac.getLabel();
		case 2:
			return ac.getBankname();
		case 3:
			return ac.getIban();
		case 4:
			return ac.getBic();
		default:
			return "";
		}
	} 
	
	public void setHolder(Physician holder) {
		this.settlements.removeAllElements();
		try {
			if (holder != null) {
				if (holder.isPersistent())
					this.settlements.addAll(settlementInterface.getTransferSettlementsByHolder(holder));
			} else {
				this.settlements.addAll(settlementInterface.getTransferSettlementsWithoutHolder());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		fireTableDataChanged();
	}
	
	
	public Settlement getSettlement(int row) {
		return settlements.get(row);
	}


}
