/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * Author: Johannes Hermen Tudor/Santec
 * Mail: johannes.hermen@tudor.lu
 * Created: Jan 17, 2005
 *
 */
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.ejb.session.beans.SettlementBean;
import lu.tudor.santec.gecamed.billing.ejb.session.interfaces.SettlementInterface;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.ButtonFactory;

import org.apache.log4j.Logger;


/**
 * represents a JPanel to show/edit Phone-Data
 *
 * @author Johannes Hermen johannes.hermen
 */ 
public class AccountPanel extends HeaderedPanel implements ActionListener
{
    //~ Static fields/initializers =============================================

	private static Logger m_Logger = Logger.getLogger ("lu.tudor.santec.gecamed.billing.gui.admin.AccountsTableModel");

    private static final long serialVersionUID = 1L;
	private JTable accountsTable;
	private AccountsTableModel accountsTableModel;
	private JButton addButton;
	private JButton deleteButton;
	private AccountEditorDialog accountEditorDialog = new AccountEditorDialog();
	private JButton editButton;
	private Physician holder;
	private SettlementInterface settlementInterface;

	private boolean isEnabled = true;

    //~ Instance fields ========================================================


    //~ Constructors ===========================================================
    /**
     * builds a new PhoneInfo to show/edit Phone-Data
     */
    public AccountPanel()
    {
    	Translatrix.addBundle("lu.tudor.santec.gecamed.billing.gui.resources.WidgetResources");
    	this.setOpaque(false);

    	try {
			settlementInterface = (SettlementInterface) ManagerFactory.getRemote(SettlementBean.class);
// 			InitialContext l_Context = new InitialContext();
// 			settlementInterface = (SettlementInterface) l_Context.lookup("SettlementBean/remote");
// 			l_Context.close();
		}
 		catch (Exception p_Exception) {
 			m_Logger.warn(p_Exception.getLocalizedMessage());
 		}

        this.buildPanel();
    }

    //~ Methods ================================================================

    /**
     *
     */
    public void setHolder(Physician holder)
    {
    	this.holder = holder;
    	if (holder != null && !holder.isPersistent()) {
    		this.addButton.setEnabled(false);
    		this.deleteButton.setEnabled(false);
    		this.editButton.setEnabled(false);
    	} else {
    		if (isEnabled) {
	    		this.addButton.setEnabled(isEnabled);
	    		this.deleteButton.setEnabled(isEnabled);
	    		this.editButton.setEnabled(isEnabled);
    		}
    	}
        this.accountsTableModel.setHolder(holder);
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel()
    {
	
	setHeader(Translatrix.getTranslationString("AccountPanel.manageAccounts"));
	
        initComponents();
        // build Layout
        this.setLayout(new BorderLayout());

        JScrollPane jsp = new JScrollPane(this.accountsTable);
        jsp.setBackground(Color.WHITE);

        jsp.getViewport().setOpaque(false);
        this.add(jsp, BorderLayout.CENTER);

        JPanel buttonPanel = new JPanel(new GridLayout(0,1));
        	
        buttonPanel.add(this.editButton);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);


        buttonPanel.setOpaque(false);
        this.add(buttonPanel, BorderLayout.EAST);

    }

    /**
     * initializes the Components
     */
    private void initComponents()
    {
    	this.accountsTableModel = new AccountsTableModel();
    	this.accountsTable = new JTable(this.accountsTableModel);
    	this.accountsTable.getColumnModel().getColumn(0).setMaxWidth(50);
    	this.accountsTable.getColumnModel().getColumn(0).setMinWidth(50);
    	this.accountsTable.getColumnModel().getColumn(3).setMaxWidth(150);
    	this.accountsTable.getColumnModel().getColumn(3).setMinWidth(150);

    	LineColorCellRenderer renderer = new LineColorCellRenderer();

    	this.accountsTable.getColumnModel().getColumn(0).setCellRenderer(this.accountsTable.getDefaultRenderer(Boolean.class));
    //	this.accountsTable.getColumnModel().getColumn(0).setCellRenderer(renderer);
    	this.accountsTable.getColumnModel().getColumn(1).setCellRenderer(renderer);
    	this.accountsTable.getColumnModel().getColumn(2).setCellRenderer(renderer);
    	this.accountsTable.getColumnModel().getColumn(3).setCellRenderer(renderer);
    	this.accountsTable.getColumnModel().getColumn(4).setCellRenderer(renderer);


    	
    	this.editButton = ButtonFactory.createNarrowButton(GECAMedModule.getSmallIcon(GECAMedModule.EDIT));
    	this.editButton.setToolTipText(Translatrix.getTranslationString("core.edit"));
    	this.editButton.setHorizontalAlignment(JButton.LEFT);
    	this.editButton.addActionListener(this);
    	
    	this.addButton = ButtonFactory.createNarrowButton(GECAMedModule.getSmallIcon(GECAMedModule.ADD_LINE));
    	this.addButton.setToolTipText(Translatrix.getTranslationString("core.add"));
    	this.addButton.setHorizontalAlignment(JButton.LEFT);
    	this.addButton.addActionListener(this);
    	
    	this.deleteButton = ButtonFactory.createNarrowButton(GECAMedModule.getSmallIcon(GECAMedModule.REMOVE_LINE));
    	this.deleteButton.setToolTipText(Translatrix.getTranslationString("core.delete"));
    	this.deleteButton.setHorizontalAlignment(JButton.LEFT);
    	this.deleteButton.addActionListener(this);

    	
    }

	public void actionPerformed(ActionEvent event) {
		if (event.getSource().equals(this.editButton)) {
			editSettlement();
		} else if (event.getSource().equals(this.addButton)) {
			addSettlement();
		} else if (event.getSource().equals(this.deleteButton)) {
			deleteSettlement();
		}
	}

	/**
	 *
	 */
	public void editSettlement() {
		if (accountsTable.getSelectedRow() != -1) {
			Settlement s =
				this.accountsTableModel.getSettlement(accountsTable.getSelectedRow());

			try {
				if (settlementInterface.checkTransferSettlementHasReferences(s)) {
					JOptionPane.showMessageDialog(MainFrame.getInstance(),
						    Translatrix.getTranslationString("AccountPanel.attentionEdit"),
						    Translatrix.getTranslationString("core.edit"),
						    JOptionPane.WARNING_MESSAGE);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			boolean ok = accountEditorDialog.editSettlement(s);
			if (ok) {
				try {
					settlementInterface.saveSettlement(s);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				setHolder(holder);
			}
		}
	}


	/**
	 *
	 */
	public void addSettlement() {
		Settlement settlement = new Settlement();
		Account ac = new Account();
		ac.setHolder(holder);
		settlement.setTransferAccount(ac);
		boolean ok = accountEditorDialog.editSettlement(settlement);
		if (ok) {
			try {
				settlementInterface.saveSettlement(settlement);
			} catch (Exception e) {
				e.printStackTrace();
			}
			setHolder(holder);
		}
	}

	/**
	 *
	 */
	public void deleteSettlement() {
		if (accountsTable.getSelectedRow() != -1) {
			Settlement s =
				this.accountsTableModel.getSettlement(accountsTable.getSelectedRow());
			try {
				if ( ! settlementInterface.checkTransferSettlementHasReferences(s)) {
					 int ok = JOptionPane.showConfirmDialog(
							 MainFrame.getInstance(),
							 Translatrix.getTranslationString("AccountPanel.reallyDelete"),
							 Translatrix.getTranslationString("core.delete"),
							 JOptionPane.YES_NO_OPTION);
					 if (ok == JOptionPane.OK_OPTION)
						 settlementInterface.deleteSettlement(s);
				} else {
					MainFrame.getInstance().showMessage(Translatrix.getTranslationString("AccountPanel.cannotDelete"),3000);
				}
			} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
			}
			setHolder(holder);
		}
	}

	public void setEditable(boolean enabled) {
		this.isEnabled = enabled;
		this.editButton.setEnabled(enabled);
		this.addButton.setEnabled(enabled);
		this.deleteButton.setEnabled(enabled);
		
	}
	
}
