/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.admin;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.gui.BillingModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.i18n.Translatrix;

public class AccountEditorDialog extends GECAMedBaseDialogImpl
{
	private static final long serialVersionUID = 1L;
	
	private JTextField labelField;
	private JTextField banknameField;
	private JTextField ibanField;
	private JTextField bicField;
	private JCheckBox obsoleteBox;
	
//	private JButton cancelButton;
//	private JButton okButton;
	
//	private boolean isOK = false;
	
	public AccountEditorDialog () 
	{
		super(MainFrame.getInstance(),
				Translatrix.getTranslationString("AccountPanel.editAccount"),
				OK_CANCEL_BUTTON_MODE);
		
		Border emptyBorder = BorderFactory.createEmptyBorder(3,3,3,3);
		
//		this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
//		this.setLayout(new BorderLayout());
		
		mainPanel.setLayout(new GridLayout(0,1));
		mainPanel.setBorder(emptyBorder);
		mainPanel.setOpaque(false);
		
		JLabel title = new JLabel(
				Translatrix.getTranslationString("AccountPanel.editAccount"));
		title.setIcon(BillingModule.getIconResource("transfer.png"));
		title.setBorder(emptyBorder);
		this.add(title, BorderLayout.NORTH);
		
		labelField	= new JTextField();
		mainPanel.add(new NamedComponent(
				Translatrix.getTranslationString("AccountPanel.accountname"), 
				labelField));
		
		banknameField = new LimitTextField(127);
		mainPanel.add(new NamedComponent(
				Translatrix.getTranslationString("AccountPanel.bankname"),
				banknameField
				));

		ibanField = new LimitTextField(32);
		mainPanel.add(new NamedComponent(
				Translatrix.getTranslationString("AccountPanel.iban"),
				ibanField
				));
		
		bicField = new LimitTextField(11);
		mainPanel.add(new NamedComponent(
				Translatrix.getTranslationString("AccountPanel.bic"),
				bicField
				));
		
		obsoleteBox=new JCheckBox("Account no more needed");
		obsoleteBox.setOpaque(false);
		
		obsoleteBox.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent e) {
				// TODO Auto-generated method stub
				//If obsolete, disable the fields
				
				labelField.setEnabled(!obsoleteBox.isSelected());
				banknameField.setEnabled(!obsoleteBox.isSelected());
				ibanField.setEnabled(!obsoleteBox.isSelected());
				bicField.setEnabled(!obsoleteBox.isSelected());
				
			}
		});
		mainPanel.add("validity",obsoleteBox);
		
//		this.add(mainPanel, BorderLayout.CENTER);
		
//		ButtonBarBuilder bbb = new ButtonBarBuilder();
		
//    	this.cancelButton = new JButton(
//    			Translatrix.getTranslationString("core.cancel"),
//    			GECAMedModule.getSmallIcon(GECAMedModule.CANCEL));
//    	this.cancelButton.addActionListener(this);
//    	this.okButton = new JButton(
//    			Translatrix.getTranslationString("core.ok"),
//    			GECAMedModule.getSmallIcon(GECAMedModule.OK));
//    	this.okButton.addActionListener(this);
    	
//    	bbb.addGlue();
//    	bbb.addGridded(cancelButton);
//    	bbb.addRelatedGap();
//    	bbb.addGridded(okButton);
    	
//    	JPanel bPanel = bbb.getPanel();
//    	bPanel.setBorder(emptyBorder);
//    	bPanel.setOpaque(false);
//    	this.add(bPanel, BorderLayout.SOUTH);
    	
    	this.setSize(400, 320);
	}

	public boolean editSettlement(Settlement settlement) {
		
		Account a = settlement.getTransferAccount();
		
		
		
		labelField.setText(a.getLabel() != null ? a.getLabel() : "");
		banknameField.setText(a.getBankname());
		ibanField.setText(a.getIban());
		bicField.setText(a.getBic());
		
		//If obsolete, disable the fields
		boolean editable = true;
		if (a.getObsolete() != null && a.getObsolete()) {
			editable = false;
		}
			
		labelField.setEnabled(editable);
		banknameField.setEnabled(editable);
		ibanField.setEnabled(editable);
		bicField.setEnabled(editable);
		obsoleteBox.setSelected(!editable);
		
		this.setLocationRelativeTo(MainFrame.getInstance());
		this.setVisible(true);
				
		if (buttonOption == OK_OPTION) 
		{
			String label	= labelField.getText().trim();
			a.setLabel(label.length() > 0 ? label : null);
			a.setBankname(banknameField.getText());
			a.setBic(bicField.getText());
			a.setIban(ibanField.getText());
			a.setObsolete(obsoleteBox.isSelected());
			return true;
		}
		
		return false;
	}

//	public void actionPerformed(ActionEvent e) {
//		if (e.getSource().equals(this.cancelButton)) {
//			this.isOK = false;
//			setVisible(false);
//		} else if (e.getSource().equals(this.okButton)) {
//			this.isOK = true;
//			setVisible(false);
//		}
//	}
}
