/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.act.addinfo;


import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.gui.act.ActListModel;

/**
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class AdditionalInfoEditorField extends AbstractCellEditor implements TableCellEditor,
																	 ActionListener, FocusListener
    {
	private static final long serialVersionUID = 1L;
	
	private static final int MODE_DEFAULT = 0;
	private static final int MODE_RADIOLOGY = 1;
	private static final int MODE_DENTAL = 2;
	
	private int 							m_Mode = MODE_DEFAULT; 
	
	private JTextField					    m_StartEditingComponent;
	private AdvancedEditorEcomponent 		m_AdvancedEditorComponent; 

	private LateralityChooser 				m_LateralityChooser;
	private ToothChooser 					m_ToothChooser;
	private ActListModel m_TableModel;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public AdditionalInfoEditorField(ActListModel model) 
    {
	super ();
	
	m_TableModel = model;
	m_LateralityChooser = new LateralityChooser(this);
	m_ToothChooser = new ToothChooser(this);
	m_StartEditingComponent = new JTextField();
	m_StartEditingComponent.addFocusListener(this);
//	m_StartEditingComponent.addActionListener(m_LateralityChooser);
//	m_StartEditingButton.setBorderPainted(false);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


//***************************************************************************
//* Class Body		                                                       *
//***************************************************************************

//---------------------------------------------------------------------------

public Object getCellEditorValue() 
	{
		if (m_Mode == MODE_DEFAULT) {
			return m_StartEditingComponent.getText();
		} else {
			return m_AdvancedEditorComponent.getValue();		
		}
	}

//---------------------------------------------------------------------------

public Component getTableCellEditorComponent(JTable p_Table, Object p_InitialValue, 
										  boolean p_IsSelected, int p_Row, int p_Column) 
	{	
	
	Act act = m_TableModel.getActAt(p_Row);
	m_Mode = MODE_DEFAULT;
	
	if (act.getCode() != null) {
		// RADIOLOGY
		if (act.getCode().startsWith("8")) {
			m_Mode = MODE_RADIOLOGY;
			m_AdvancedEditorComponent = m_LateralityChooser;
			m_AdvancedEditorComponent.setValue((String)p_InitialValue);
		// DENTAL
		} else if (act.getCode().startsWith("D")) {
			m_Mode = MODE_DENTAL;
			m_AdvancedEditorComponent = m_ToothChooser;
			m_AdvancedEditorComponent.setValue((String)p_InitialValue);
		} else {
			m_AdvancedEditorComponent = null;
		}
	}
	
	m_StartEditingComponent.setText((String)p_InitialValue);
	return m_StartEditingComponent;
	}

//---------------------------------------------------------------------------

public void actionPerformed(ActionEvent e) 
	{
		if (m_Mode != MODE_DEFAULT) {
			m_AdvancedEditorComponent.actionPerformed(e);		
		}
	}

public void focusGained(FocusEvent e) {
	if (m_Mode != MODE_DEFAULT) {
		m_AdvancedEditorComponent.actionPerformed(new ActionEvent(m_StartEditingComponent, 1, ""));
	}
}

public void focusLost(FocusEvent e) {
}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}

