/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui.act;


import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;


/**
 * @author 
 * 
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class UsernameRenderer implements TableCellRenderer
																   
    {
	private JLabel renderLabel = new JLabel();
     
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public UsernameRenderer() 
    {
	super ();
	renderLabel.setOpaque(true);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************


//---------------------------------------------------------------------------

	public Component getTableCellRendererComponent(JTable p_Table, Object p_Value, boolean p_IsSelected, boolean p_HasFocus, int p_Row, int p_Column) {

		if (p_Value instanceof String) {
			renderLabel.setText((String) p_Value);
			if (p_Value != null) {
				renderLabel.setToolTipText("<html>"+ ((String) p_Value).replaceAll("\n", "<br>"));
							
			}
		}
		
		Color l_Background = null;
		if ((p_Table != null) && (p_IsSelected)) 
			l_Background = p_Table.getSelectionBackground();
		else 
			l_Background = (p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : GECAMedColors.c_EvenLineBackground;
		renderLabel.setBackground(l_Background);

		return renderLabel;
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************


//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}



