/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class GenericListRenderer extends DefaultTableCellRenderer 
	{
	protected JLabel              		m_Label;
	protected boolean					m_IsAlarm;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final long serialVersionUID = 1L;
 	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
   
public GenericListRenderer ()
      {
     super();

     m_Label = new JLabel ();
     m_Label.setOpaque(true);
     m_Label.setHorizontalAlignment (SwingConstants.CENTER);
     m_Label.setToolTipText(null);
     m_Label.setText(null);
      }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//---------------------------------------------------------------------------

public int modelColumn (JTable p_Table, int p_ViewColumn) 
	{
    if (p_ViewColumn >= p_Table.getColumnCount()) return -1;
  
    return p_Table.getColumnModel().getColumn(p_ViewColumn).getModelIndex();
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Color			l_Background;
	
	m_Label.setIcon (null);
	m_Label.setToolTipText (null);
	m_Label.setText ("");
	m_Label.setHorizontalAlignment (SwingConstants.CENTER);
	m_Label.setForeground (Color.BLACK);

	m_Label.setEnabled (p_Table.isEnabled());

	if (!m_IsAlarm)
		{
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_OddLineBackground : 
									 	   GECAMedColors.c_EvenLineBackground;
		}
	else
		{
		l_Background = ( p_Row % 2 == 0) ? GECAMedColors.c_RedOddLineBackground : 
	     	   							   GECAMedColors.c_RedEvenLineBackground;
		}
	
	if (p_IsSelected) 
		{
		m_Label.setBackground(p_Table.getSelectionBackground());
		} 
	else 
		{
		m_Label.setBackground(l_Background);
		}

return m_Label;
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
