/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.gui;

import java.text.ParseException;

import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;


/**
 * The AccidentNumberField swing component eases the input 
 * @author nmac
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class AccidentNumberField extends JFormattedTextField
    {
    private static final long serialVersionUID = 1L;
    
    public static final String c_EmptyField = "-----/-----";
    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public AccidentNumberField () 
    {
    super ();
    
    installFormatter("U####/#####");
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------
/**
 * creates a MaskFormatter object using the specified format template
 * @param p_Format specifies the template for new MaskFormatter object
 * @return MaskFormatter object implementing format specified by p_Format
 */
//---------------------------------------------------------------------------

protected void installFormatter (String p_Format) 
    {
    MaskFormatter l_Formatter = null;
    
    try {
        l_Formatter = new MaskFormatter (p_Format);
        l_Formatter.setValidCharacters("UL0123456789");
        l_Formatter.setPlaceholderCharacter('-');
        l_Formatter.setAllowsInvalid(false);		
        l_Formatter.install(this);
    		} 
    catch (ParseException p_Exception) 
        {
        }
    }

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************


//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}
