/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.TrashedInvoiceStub;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

public interface TrashedInvoiceStubInterface 
	{
	public Long								getInvoiceStubCountByWhereClause (WhereClause p_Clause) throws Exception;
	
	public Collection <TrashedInvoiceStub> 	getAllTrashedInvoiceStubs 	     () throws Exception;
	
	public Collection <TrashedInvoiceStub> 	getInvoiceStubsByWhereClause 	 (WhereClause p_Clause) throws Exception;
			
	public Invoice 							undeleteInvoice 				 (Integer p_InvoiceId) throws Exception;
	
	public  void deleteTrashedInvoiceByID (Integer p_ID) throws Exception;

	}
