/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Statement;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The StatementInvoiceStubInterface 
* @author nmac
* @since 07/06/01
*
*/

@Remote
public interface StatementInvoiceStubInterface 
	{
	public InvoiceStub					getInvoiceStubById				  	(Integer p_Id) throws Exception;
	
	public Long 						getInvoiceStubCountForStatement   	(Statement p_Statement) throws Exception; 
	
	public void							buildInvoiceStubQueryForStatement 	(Statement p_Statement) throws Exception;
	
	public void							setFirstInvoiceStub				  	(Integer p_FirstInvoiceStub);
	
	public void							setNumberOfInvoiceStubs			  	(Integer p_NumberOfInvoiceStubs);
	
	public Collection <InvoiceStub> 	getNextInvoiceStubs 			  	() throws Exception;
	
	public void							close ();
	
	public void							closeInvoicesForStatement 			(Statement p_Statement, Collection <Integer> p_InvoiceIDs) throws Exception;
	
	public void							openInvoicesForStatement  			(Statement p_Statement, Collection <Integer> p_InvoiceIDs) throws Exception;
	
	public Long							settledInvoiceCountForStatement		(Statement p_Statement) throws Exception;
	
	public void							remove ();

	//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
