/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The ReminderInvoiceInterface 
* @author nmac
* @since 07/04/06
*
*/

@Remote
public interface ReminderInvoiceStubInterface 
	{
	public void							setCeiling					(Integer p_Ceiling);
	
	public Long 						getInvoiceStubCount 		(Integer p_QueryMode) throws Exception; 
		
	public Collection <Long>			getAllInvoiceStubCounts 	() throws Exception;
	
	public Collection <Integer>			filterByQueryMode			(Integer p_QueryMode, Collection <Integer> p_SubSetIds) throws Exception;			
	
	public Collection <InvoiceStub>		getInvoiceStubsByIds		(Collection <Integer> p_InvoiceIds) throws Exception;
	
	public void							buildInvoiceStubQuery 		(Integer p_QueryMode) throws Exception;
	
	public void							setPhysician				(Physician p_Physician);
	
	public void							setOnlyExpired				(Boolean p_OnlyExpired);
	
	public void							setWhereClause				(WhereClause p_WhereClause);
	
	public void							setFirstInvoiceStub			(Integer p_FirstInvoiceStub);
	
	public void							setNumberOfInvoiceStubs		(Integer p_NumberOfInvoiceStubs);
	
	public Collection <InvoiceStub> 	getNextInvoiceStubs 		() throws Exception;
	
	public void							close 						();
	
	public void							remove 						();
	
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
