/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceTemplate;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

public interface InvoiceTemplateInterface 
	{
	public Collection<InvoiceTemplate> getAllTemplates () throws Exception;
	
	public Collection<InvoiceTemplate> getTemplatesByUser (Integer p_UserID) throws Exception;	
	
	public InvoiceTemplate	saveTemplate (InvoiceTemplate p_Template) throws Exception;
	
	public void				deleteTemplate (InvoiceTemplate p_Template) throws Exception;
	}
