/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Act;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Memo;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Suffix;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.TrashedAct;
import lu.tudor.santec.gecamed.core.utils.querybuilder.WhereClause;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Hospitalisation;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationClass;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The InvoiceInterface
* @author nmac
* @since 06/05/02
*
*/

@Remote
public interface InvoiceInterface
	{
//***************************************************************************
//* Constants						                                        *
//***************************************************************************

	public static final int c_PatientDependency 		= 1;
	public static final int c_HospitalisationDependency = 2;
	public static final int c_CloserDependency 			= 3;
	public static final int c_ModifierDependency 		= 4;
	
//***************************************************************************
//* Interface	  					                                        *
//***************************************************************************
	
	
	public void							initializeFactors () throws Exception;

	public Collection <Insurance> 		getThirdPartyPayingInsurances() throws Exception;

	public Invoice   					getInvoiceByID (Integer p_ID) throws Exception;
	
	public Invoice						getInvoiceByAccessionNumber (String p_AccessionNumber) throws Exception;

	public Collection <Invoice> 		getInvoicesByPatient (Patient p_Patient) throws Exception;
	
	public Collection <Invoice> 		getInvoicesByPatientAndPhysician (Patient p_Patient, Physician p_Physician) throws Exception;
	
	public Invoice 						getInvoiceByPatientPhysicianAndDate (Patient p_Patient, Physician p_Physician, Date p_Date, Integer p_OpenInvoiceId);
	
	public Invoice						getInvoiceByAct (Patient p_Patient, Physician p_Physician, Date p_FromDate, Date p_ToDate, String p_Code, Integer p_ExcludedInvoiceId);

	public Collection <Invoice> 		getInvoicesByHospitalisation (Hospitalisation p_Hospitalisation) throws Exception;

	public Long							getInvoiceCountByWhereClause (WhereClause p_Clause) throws Exception;
	
	public Collection <Invoice> 		getInvoicesByWhereClause (WhereClause p_Clause) throws Exception;

	public Act							getActByAccessionNumber (String p_AccessionNumber) throws Exception;
	
	public Invoice						fetchLazyDependencies (Invoice p_Invoice, Collection <Integer> p_Dependencies) throws Exception;
	
	public Invoice 						fetchPatientForInvoice (Invoice p_Invoice) throws Exception;

	public Invoice 						fetchHospitalisationForInvoice (Invoice p_Invoice) throws Exception;

	public Invoice 						fetchCloserForInvoice (Invoice p_Invoice) throws Exception;

	public Invoice 						fetchModifierForInvoice (Invoice p_Invoice) throws Exception;

	public Set <Act>					verifyActs (Set <Act> p_Unverified) throws Exception;
	
	public Invoice						saveActs (Invoice p_Invoice, Set <Act> p_Acts) throws Exception;
	
	public void							saveActs (Set<Act> p_Acts) throws Exception;
	
	public Act							saveAct (Act p_Act) throws Exception;
	
	public TrashedAct					saveTrashedAct (TrashedAct p_Act) throws Exception;

	public Memo 						fetchAuthorForMemo (Memo p_Memo) throws Exception;

	public Invoice						saveMemos (Invoice p_Invoice, Set <Memo> p_Memos) throws Exception;

	public Invoice						saveInvoice (Invoice p_Invoice) throws Exception;

	public void							deleteInvoice (Invoice p_Invoice) throws Exception;

	public List<Invoice>				getInvoicesForAccident (String p_AccidentNumber, Date p_AccidentDate, Patient p_Patient);
	
	public int							getNoOfActsWithoutSetAmount ();
	
	public List<Act>					getActsWithoutSetAmount (int maxActs);
	
	public List<TrashedAct>				getTrashedActsWithoutSetAmount (int maxActs);
	
	public Suffix						getSuffix (char letter);
	
	public int							getNoOfInvoicesWithNegativeAmounts ();
	
	public List<Invoice>				getInvoicesWithNegativeAmount (int max);
	
	public List<Invoice> splitFirstClassHospitalizedInvoice (Invoice invoice) throws Exception;
	
	public Boolean isInvoiceSplittable (Invoice invoice);
	
	public HospitalisationClass getHospitalisationClass(String p_Acronym) throws Exception;
	
	
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
